/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.nnet.comp.DelayedConnection;
import org.neuroph.nnet.comp.neuron.BiasNeuron;

public class ConnectionFactory {
    public static void createConnection(Neuron fromNeuron, Neuron toNeuron) {
        Connection connection = new Connection(fromNeuron, toNeuron);
        toNeuron.addInputConnection(connection);
    }

    public static void createConnection(Neuron fromNeuron, Neuron toNeuron, double weightVal) {
        Connection connection = new Connection(fromNeuron, toNeuron, weightVal);
        toNeuron.addInputConnection(connection);
    }

    public static void createConnection(Neuron fromNeuron, Neuron toNeuron, double weightVal, int delay) {
        DelayedConnection connection = new DelayedConnection(fromNeuron, toNeuron, weightVal, delay);
        toNeuron.addInputConnection(connection);
    }

    public static void createConnection(Neuron fromNeuron, Neuron toNeuron, Weight weight) {
        Connection connection = new Connection(fromNeuron, toNeuron, weight);
        toNeuron.addInputConnection(connection);
    }

    public static void createConnection(Neuron fromNeuron, Layer toLayer) {
        for (Neuron toNeuron : toLayer.getNeurons()) {
            ConnectionFactory.createConnection(fromNeuron, toNeuron);
        }
    }

    public static void fullConnect(Layer fromLayer, Layer toLayer) {
        for (Neuron fromNeuron : fromLayer.getNeurons()) {
            for (Neuron toNeuron : toLayer.getNeurons()) {
                ConnectionFactory.createConnection(fromNeuron, toNeuron);
            }
        }
    }

    public static void fullConnect(Layer fromLayer, Layer toLayer, boolean connectBiasNeuron) {
        for (Neuron fromNeuron : fromLayer.getNeurons()) {
            if (fromNeuron instanceof BiasNeuron) continue;
            for (Neuron toNeuron : toLayer.getNeurons()) {
                ConnectionFactory.createConnection(fromNeuron, toNeuron);
            }
        }
    }

    public static void fullConnect(Layer fromLayer, Layer toLayer, double weightVal) {
        for (Neuron fromNeuron : fromLayer.getNeurons()) {
            for (Neuron toNeuron : toLayer.getNeurons()) {
                ConnectionFactory.createConnection(fromNeuron, toNeuron, weightVal);
            }
        }
    }

    public static void fullConnect(Layer layer) {
        int neuronNum = layer.getNeuronsCount();
        for (int i = 0; i < neuronNum; ++i) {
            for (int j = 0; j < neuronNum; ++j) {
                if (j == i) continue;
                Neuron from = layer.getNeuronAt(i);
                Neuron to = layer.getNeuronAt(j);
                ConnectionFactory.createConnection(from, to);
            }
        }
    }

    public static void fullConnect(Layer layer, double weightVal) {
        int neuronNum = layer.getNeuronsCount();
        for (int i = 0; i < neuronNum; ++i) {
            for (int j = 0; j < neuronNum; ++j) {
                if (j == i) continue;
                Neuron from = layer.getNeuronAt(i);
                Neuron to = layer.getNeuronAt(j);
                ConnectionFactory.createConnection(from, to, weightVal);
            }
        }
    }

    public static void fullConnect(Layer layer, double weightVal, int delay) {
        int neuronNum = layer.getNeuronsCount();
        for (int i = 0; i < neuronNum; ++i) {
            for (int j = 0; j < neuronNum; ++j) {
                if (j == i) continue;
                Neuron from = layer.getNeuronAt(i);
                Neuron to = layer.getNeuronAt(j);
                ConnectionFactory.createConnection(from, to, weightVal, delay);
            }
        }
    }

    public static void forwardConnect(Layer fromLayer, Layer toLayer, double weightVal) {
        for (int i = 0; i < fromLayer.getNeuronsCount(); ++i) {
            Neuron fromNeuron = fromLayer.getNeuronAt(i);
            Neuron toNeuron = toLayer.getNeuronAt(i);
            ConnectionFactory.createConnection(fromNeuron, toNeuron, weightVal);
        }
    }

    public static void forwardConnect(Layer fromLayer, Layer toLayer) {
        for (int i = 0; i < fromLayer.getNeuronsCount(); ++i) {
            Neuron fromNeuron = fromLayer.getNeuronAt(i);
            Neuron toNeuron = toLayer.getNeuronAt(i);
            ConnectionFactory.createConnection(fromNeuron, toNeuron, 1.0);
        }
    }
}

