/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.uci;

import java.util.Arrays;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.MomentumBackpropagation;

public class ConceptLearningAndClassificationSample
implements LearningEventListener {
    public static void main(String[] args) {
        new ConceptLearningAndClassificationSample().run();
    }

    public void run() {
        System.out.println("Creating training set...");
        String trainingSetFileName = "data_sets/concept_learning_and_classification_data_1.txt";
        int inputsCount = 15;
        int outputsCount = 3;
        DataSet dataSet = DataSet.createFromFile(trainingSetFileName, inputsCount, outputsCount, ",", false);
        System.out.println("Creating neural network...");
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(inputsCount, 10, outputsCount);
        MomentumBackpropagation learningRule = (MomentumBackpropagation)neuralNet.getLearningRule();
        learningRule.addListener(this);
        learningRule.setLearningRate(0.2);
        learningRule.setMomentum(0.7);
        learningRule.setMaxError(0.01);
        System.out.println("Training network...");
        neuralNet.learn(dataSet);
        System.out.println("Training completed.");
        System.out.println("Testing network...");
        this.testNeuralNetwork(neuralNet, dataSet);
        System.out.println("Saving network");
        neuralNet.save("MyNeuralNetConceptLearning.nnet");
        System.out.println("Done.");
    }

    public void testNeuralNetwork(NeuralNetwork neuralNet, DataSet testSet) {
        for (DataSetRow testSetRow : testSet.getRows()) {
            neuralNet.setInput(testSetRow.getInput());
            neuralNet.calculate();
            double[] networkOutput = neuralNet.getOutput();
            System.out.print("Input: " + Arrays.toString(testSetRow.getInput()));
            System.out.println(" Output: " + Arrays.toString(networkOutput));
        }
    }

    @Override
    public void handleLearningEvent(LearningEvent event) {
        BackPropagation bp = (BackPropagation)event.getSource();
        System.out.println(bp.getCurrentIteration() + ". iteration | Total network error: " + bp.getTotalNetworkError());
    }
}

