/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.forestCover;

import java.io.IOException;
import org.neuroph.samples.forestCover.Config;
import org.neuroph.samples.forestCover.Evaluate;
import org.neuroph.samples.forestCover.GenerateData;
import org.neuroph.samples.forestCover.TrainNetwork;

public class ForestCoverType {
    public static void generateDataSets(Config config) {
        GenerateData generate = new GenerateData(config);
        System.out.println("***************************************************");
        System.out.println("STEP 1: Generate training (75%) and test (25%) files: ");
        generate.createTrainingAndTestSet();
        System.out.println("***************************************************");
        System.out.println("STEP 2: Balancing training data set to have the same number (3000) of each tree: ");
        generate.createBalancedTrainingSet(3000);
        System.out.println("***************************************************");
        System.out.println("STEP 3: Normalizing balanced training data set: ");
        generate.normalizeBalancedTrainingSet();
    }

    public static void trainNetwork(Config config) {
        TrainNetwork program = new TrainNetwork(config);
        System.out.println("***************************************************");
        System.out.println("STEP 4: Creating and Training neural network: ");
        program.createNeuralNetwork();
        program.train();
        ForestCoverType.evaluateNetwork(config);
    }

    public static void evaluateNetwork(Config config) {
        Evaluate evaluate = new Evaluate(config);
        System.out.println("***************************************************");
        System.out.println("STEP 5: Evaluating neural network: ");
        evaluate.evaluate();
    }

    public static void main(String[] args) throws IOException {
        Config config = new Config();
        ForestCoverType.generateDataSets(config);
        ForestCoverType.trainNetwork(config);
        ForestCoverType.evaluateNetwork(config);
    }
}

