/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.evaluation.optimization;

import java.io.IOException;
import org.neuroph.contrib.model.modelselection.MultilayerPerceptronOptimazer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.eval.Evaluation;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.samples.convolution.mnist.MNISTDataSet;

public class MLPMNISTOptimization {
    public static void main(String[] args) throws IOException {
        DataSet trainSet = MNISTDataSet.createFromFile("data_sets/train-labels.idx1-ubyte", "data_sets/train-images.idx3-ubyte", 200);
        DataSet testSet = MNISTDataSet.createFromFile("data_sets/t10k-labels.idx1-ubyte", "data_sets/t10k-images.idx3-ubyte", 10000);
        BackPropagation learningRule = MLPMNISTOptimization.createLearningRule();
        NeuralNetwork neuralNet = new MultilayerPerceptronOptimazer().withLearningRule(learningRule).createOptimalModel(trainSet);
        Evaluation.runFullEvaluation(neuralNet, testSet);
    }

    private static BackPropagation createLearningRule() {
        BackPropagation learningRule = new BackPropagation();
        learningRule.setMaxIterations(100);
        learningRule.setMaxError(1.0E-4);
        return learningRule;
    }
}

