/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.nnet.learning.BackPropagation;

public class ManhattanPropagation
extends BackPropagation {
    @Override
    public void calculateWeightChanges(Neuron neuron) {
        double delta = neuron.getDelta();
        for (Connection connection : neuron.getInputConnections()) {
            double input = connection.getInput();
            double weightChange = -this.learningRate * Math.signum(delta * input);
            Weight weight = connection.getWeight();
            if (!this.isBatchMode()) {
                weight.weightChange = weightChange;
                continue;
            }
            weight.weightChange += weightChange;
        }
    }
}

