/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.io.Serializable;
import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.learning.SupervisedLearning;

public class LMS
extends SupervisedLearning
implements Serializable {
    private static final long serialVersionUID = 2L;

    @Override
    protected void calculateWeightChanges(double[] outputError) {
        int i = 0;
        List<Neuron> outputNeurons = this.neuralNetwork.getOutputNeurons();
        for (Neuron neuron : outputNeurons) {
            neuron.setDelta(outputError[i]);
            this.calculateWeightChanges(neuron);
            ++i;
        }
    }

    protected void calculateWeightChanges(Neuron neuron) {
        double delta = neuron.getDelta();
        for (Connection connection : neuron.getInputConnections()) {
            double input = connection.getInput();
            double weightChange = -this.learningRate * delta * input;
            Weight weight = connection.getWeight();
            if (!this.isBatchMode()) {
                weight.weightChange = weightChange;
                continue;
            }
            weight.weightChange += weightChange;
        }
    }
}

