/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.learning.LearningRule;

public class HopfieldLearning
extends LearningRule {
    private static final long serialVersionUID = 1L;

    @Override
    public void learn(DataSet trainingSet) {
        int M = trainingSet.size();
        int N = this.neuralNetwork.getLayerAt(0).getNeuronsCount();
        Layer hopfieldLayer = this.neuralNetwork.getLayerAt(0);
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                if (j == i) continue;
                Neuron ni = hopfieldLayer.getNeuronAt(i);
                Neuron nj = hopfieldLayer.getNeuronAt(j);
                Connection cij = nj.getConnectionFrom(ni);
                Connection cji = ni.getConnectionFrom(nj);
                double w = 0.0;
                for (int k = 0; k < M; ++k) {
                    DataSetRow trainingSetRow = trainingSet.getRowAt(k);
                    double pki = trainingSetRow.getInput()[i];
                    double pkj = trainingSetRow.getInput()[j];
                    w += pki * pkj;
                }
                cij.getWeight().setValue(w);
                cji.getWeight().setValue(w);
            }
        }
    }
}

