/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.util.NeuronFactory;
import org.neuroph.util.NeuronProperties;

public class FeatureMapLayer
extends Layer {
    private static final long serialVersionUID = 2498669699995172395L;
    private Dimension2D dimensions;
    private Kernel kernel;

    public FeatureMapLayer(Dimension2D dimensions, NeuronProperties neuronProperties) {
        this.dimensions = dimensions;
        for (int i = 0; i < dimensions.getHeight() * dimensions.getWidth(); ++i) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            this.addNeuron(neuron);
        }
    }

    public FeatureMapLayer(Dimension2D dimensions, Dimension2D kernelDimension) {
        this.dimensions = dimensions;
        this.kernel = new Kernel(kernelDimension);
    }

    public FeatureMapLayer(Dimension2D dimensions, NeuronProperties neuronProperties, Dimension2D kernelDimension) {
        this(dimensions, kernelDimension);
        for (int i = 0; i < dimensions.getHeight() * dimensions.getWidth(); ++i) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            this.addNeuron(neuron);
        }
    }

    public int getWidth() {
        return this.dimensions.getWidth();
    }

    public int getHeight() {
        return this.dimensions.getHeight();
    }

    public Dimension2D getDimensions() {
        return this.dimensions;
    }

    public Neuron getNeuronAt(int x, int y) {
        return this.getNeuronAt(x + y * this.dimensions.getWidth());
    }

    public Kernel getKernel() {
        return this.kernel;
    }
}

