/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp;

import java.io.Serializable;
import org.neuroph.core.Weight;
import org.neuroph.nnet.comp.Dimension2D;

public class Kernel
implements Serializable {
    private static final long serialVersionUID = -3948374914759253222L;
    private int width;
    private int height;
    private Weight[][] weights;

    public Kernel(Dimension2D dimension) {
        this.width = dimension.getWidth();
        this.height = dimension.getHeight();
    }

    public Kernel(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getArea() {
        return this.width * this.height;
    }

    public Weight[][] getWeights() {
        return this.weights;
    }

    public void setWeights(Weight[][] weights) {
        this.weights = weights;
    }

    public void initWeights(double min, double max) {
        this.weights = new Weight[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                Weight weight = new Weight();
                weight.randomize(min, max);
                this.weights[i][j] = weight;
            }
        }
    }
}

