/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Linear;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.comp.neuron.InputNeuron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;
import org.neuroph.util.random.RangeRandomizer;

public class MultiLayerPerceptron
extends NeuralNetwork<BackPropagation> {
    private static final long serialVersionUID = 2L;

    public MultiLayerPerceptron(List<Integer> neuronsInLayers) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", true);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
        this.createNetwork(neuronsInLayers, neuronProperties);
    }

    public MultiLayerPerceptron(int ... neuronsInLayers) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", true);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
        neuronProperties.setProperty("inputFunction", WeightedSum.class);
        ArrayList<Integer> neuronsInLayersVector = new ArrayList<Integer>();
        for (int i = 0; i < neuronsInLayers.length; ++i) {
            neuronsInLayersVector.add(neuronsInLayers[i]);
        }
        this.createNetwork(neuronsInLayersVector, neuronProperties);
    }

    public MultiLayerPerceptron(TransferFunctionType transferFunctionType, int ... neuronsInLayers) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", true);
        neuronProperties.setProperty("transferFunction", (Object)transferFunctionType);
        neuronProperties.setProperty("inputFunction", WeightedSum.class);
        ArrayList<Integer> neuronsInLayersVector = new ArrayList<Integer>();
        for (int i = 0; i < neuronsInLayers.length; ++i) {
            neuronsInLayersVector.add(neuronsInLayers[i]);
        }
        this.createNetwork(neuronsInLayersVector, neuronProperties);
    }

    public MultiLayerPerceptron(List<Integer> neuronsInLayers, TransferFunctionType transferFunctionType) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", true);
        neuronProperties.setProperty("transferFunction", (Object)transferFunctionType);
        this.createNetwork(neuronsInLayers, neuronProperties);
    }

    public MultiLayerPerceptron(List<Integer> neuronsInLayers, NeuronProperties neuronProperties) {
        this.createNetwork(neuronsInLayers, neuronProperties);
    }

    private void createNetwork(List<Integer> neuronsInLayers, NeuronProperties neuronProperties) {
        this.setNetworkType(NeuralNetworkType.MULTI_LAYER_PERCEPTRON);
        NeuronProperties inputNeuronProperties = new NeuronProperties(InputNeuron.class, Linear.class);
        Layer layer = LayerFactory.createLayer((int)neuronsInLayers.get(0), inputNeuronProperties);
        boolean useBias = true;
        if (neuronProperties.hasProperty("useBias")) {
            useBias = (Boolean)neuronProperties.getProperty("useBias");
        }
        if (useBias) {
            layer.addNeuron(new BiasNeuron());
        }
        this.addLayer(layer);
        Layer prevLayer = layer;
        for (int layerIdx = 1; layerIdx < neuronsInLayers.size(); ++layerIdx) {
            Integer neuronsNum = neuronsInLayers.get(layerIdx);
            layer = LayerFactory.createLayer((int)neuronsNum, neuronProperties);
            if (useBias && layerIdx < neuronsInLayers.size() - 1) {
                layer.addNeuron(new BiasNeuron());
            }
            this.addLayer(layer);
            if (prevLayer != null) {
                ConnectionFactory.fullConnect(prevLayer, layer);
            }
            prevLayer = layer;
        }
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new MomentumBackpropagation());
        this.randomizeWeights(new RangeRandomizer(-0.7, 0.7));
    }

    public void connectInputsToOutputs() {
        ConnectionFactory.fullConnect(this.getLayerAt(0), this.getLayerAt(this.getLayersCount() - 1), false);
    }
}

