/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.neuron.InputOutputNeuron;
import org.neuroph.nnet.learning.BinaryHebbianLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class Hopfield
extends NeuralNetwork {
    private static final long serialVersionUID = 2L;

    public Hopfield(int neuronsCount) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("neuronType", InputOutputNeuron.class);
        neuronProperties.setProperty("bias", new Double(0.0));
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        neuronProperties.setProperty("transferFunction.yHigh", new Double(1.0));
        neuronProperties.setProperty("transferFunction.yLow", new Double(0.0));
        this.createNetwork(neuronsCount, neuronProperties);
    }

    public Hopfield(int neuronsCount, NeuronProperties neuronProperties) {
        this.createNetwork(neuronsCount, neuronProperties);
    }

    private void createNetwork(int neuronsCount, NeuronProperties neuronProperties) {
        this.setNetworkType(NeuralNetworkType.HOPFIELD);
        Layer layer = LayerFactory.createLayer(neuronsCount, neuronProperties);
        ConnectionFactory.fullConnect(layer, 0.1);
        this.addLayer(layer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new BinaryHebbianLearning());
    }
}

