/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.exceptions.NeurophException;
import org.neuroph.core.exceptions.VectorSizeMismatchException;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.ConvolutionalUtils;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.layer.ConvolutionalLayer;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.InputMapsLayer;
import org.neuroph.nnet.comp.layer.PoolingLayer;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.learning.ConvolutionalBackpropagation;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class ConvolutionalNetwork
extends NeuralNetwork<ConvolutionalBackpropagation> {
    private static final long serialVersionUID = -1393907449047650509L;

    @Override
    public void setInput(double ... inputVector) throws VectorSizeMismatchException {
        FeatureMapsLayer inputLayer = (FeatureMapsLayer)this.getLayerAt(0);
        int currentNeuron = 0;
        for (int i = 0; i < inputLayer.getNumberOfMaps(); ++i) {
            FeatureMapLayer map = inputLayer.getFeatureMap(i);
            for (Neuron neuron : map.getNeurons()) {
                if (neuron instanceof BiasNeuron) continue;
                neuron.setInput(inputVector[currentNeuron++]);
            }
        }
    }

    public static class Builder {
        public static final NeuronProperties DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES = new NeuronProperties();
        private ConvolutionalNetwork network = new ConvolutionalNetwork();

        public Builder withInputLayer(int width, int height, int numberOfMaps) {
            if (this.network.getLayersCount() > 0) {
                throw new NeurophException("Input layer must be the first layer in network");
            }
            InputMapsLayer inputLayer = new InputMapsLayer(new Dimension2D(width, height), numberOfMaps);
            inputLayer.setLabel("Input Layer");
            this.network.addLayer(inputLayer);
            return this;
        }

        public Builder withConvolutionLayer(int kernelWidth, int kernelHeight, int numberOfMaps) {
            FeatureMapsLayer prevLayer = this.getLastFeatureMapLayer();
            ConvolutionalLayer convolutionLayer = new ConvolutionalLayer(prevLayer, new Dimension2D(kernelWidth, kernelHeight), numberOfMaps);
            this.network.addLayer(convolutionLayer);
            ConvolutionalUtils.fullConnectMapLayers(prevLayer, convolutionLayer);
            return this;
        }

        public Builder withConvolutionLayer(Dimension2D kernelDimension, int numberOfMaps, Class<? extends TransferFunction> transferFunction) {
            FeatureMapsLayer prevLayer = this.getLastFeatureMapLayer();
            ConvolutionalLayer convolutionLayer = new ConvolutionalLayer(prevLayer, kernelDimension, numberOfMaps, transferFunction);
            this.network.addLayer(convolutionLayer);
            ConvolutionalUtils.fullConnectMapLayers(prevLayer, convolutionLayer);
            return this;
        }

        public Builder withPoolingLayer(int width, int height) {
            FeatureMapsLayer lastLayer = this.getLastFeatureMapLayer();
            PoolingLayer poolingLayer = new PoolingLayer(lastLayer, new Dimension2D(width, height));
            this.network.addLayer(poolingLayer);
            ConvolutionalUtils.fullConnectMapLayers(lastLayer, poolingLayer);
            return this;
        }

        public Builder withFullConnectedLayer(int numberOfNeurons) {
            Layer lastLayer = this.getLastLayer();
            Layer fullConnectedLayer = new Layer(numberOfNeurons, DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES);
            this.network.addLayer(fullConnectedLayer);
            ConnectionFactory.fullConnect(lastLayer, fullConnectedLayer);
            return this;
        }

        public Builder withFullConnectedLayer(Layer layer) {
            Layer lastLayer = this.getLastLayer();
            this.network.addLayer(layer);
            ConnectionFactory.fullConnect(lastLayer, layer);
            return this;
        }

        public ConvolutionalNetwork build() {
            this.network.setInputNeurons(this.network.getLayerAt(0).getNeurons());
            this.network.setOutputNeurons(this.getLastLayer().getNeurons());
            this.network.setLearningRule(new ConvolutionalBackpropagation());
            return this.network;
        }

        private FeatureMapsLayer getLastFeatureMapLayer() {
            Layer layer = this.getLastLayer();
            if (layer instanceof FeatureMapsLayer) {
                return (FeatureMapsLayer)layer;
            }
            throw new RuntimeException("Unable to add next layer because previous layer is not FeatureMapLayer");
        }

        private Layer getLastLayer() {
            return this.network.getLayerAt(this.network.getLayersCount() - 1);
        }

        static {
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("useBias", true);
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("inputFunction", WeightedSum.class);
        }
    }
}

