/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class OCRCropImage
implements ImageFilter {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;

    public void setDimension(int width, int height) {
        this.newHeight = height;
        this.newWidth = width;
    }

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.originalImage = image;
        this.filteredImage = new BufferedImage(this.newWidth, this.newHeight, image.getType());
        int startH = this.createStartH();
        int startW = this.createStartW();
        int endH = this.createEndH();
        int endW = this.createEndW();
        this.fillImage(startH, startW, endH, endW);
        return this.filteredImage;
    }

    private int createStartH() {
        int black = 0;
        int startH = 0;
        block0: for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int color = new Color(this.originalImage.getRGB(j, i)).getRed();
                if (color != black) continue;
                startH = i;
                break block0;
            }
        }
        return startH;
    }

    private int createStartW() {
        int black = 0;
        int startW = 0;
        block0: for (int j = 0; j < this.width; ++j) {
            for (int i = 0; i < this.height; ++i) {
                int color = new Color(this.originalImage.getRGB(j, i)).getRed();
                if (color != black) continue;
                startW = j;
                break block0;
            }
        }
        return startW;
    }

    private int createEndH() {
        int black = 0;
        int endH = 0;
        block0: for (int i = this.height - 1; i >= 0; --i) {
            for (int j = this.width - 1; j >= 0; --j) {
                int color = new Color(this.originalImage.getRGB(j, i)).getRed();
                if (color != black) continue;
                endH = i;
                break block0;
            }
        }
        return endH;
    }

    private int createEndW() {
        int black = 0;
        int endW = 0;
        block0: for (int j = this.width - 1; j >= 0; --j) {
            for (int i = this.height - 1; i >= 0; --i) {
                int color = new Color(this.originalImage.getRGB(j, i)).getRed();
                if (color != black) continue;
                endW = j;
                break block0;
            }
        }
        return endW;
    }

    private void fillImage(int startH, int startW, int endH, int endW) {
        int alpha = new Color(this.originalImage.getRGB(this.width / 2, this.height / 2)).getRed();
        int whiteRGB = ImageUtilities.colorToRGB(alpha, 255, 255, 255);
        for (int i = 0; i < this.newHeight; ++i) {
            for (int j = 0; j < this.newWidth; ++j) {
                this.filteredImage.setRGB(j, i, whiteRGB);
            }
        }
        int oldCenterH = (startH + endH) / 2;
        int oldCenterW = (startW + endW) / 2;
        int newCenterH = this.newHeight / 2;
        int newCenterW = this.newWidth / 2;
        boolean[][] visited = new boolean[this.newHeight][this.newWidth];
        LinkedList<String> queue = new LinkedList<String>();
        String pos = newCenterH + " " + newCenterW + " " + oldCenterH + " " + oldCenterW;
        queue.addLast(pos);
        visited[newCenterH][newCenterW] = true;
        try {
            while (!queue.isEmpty()) {
                String tmp = (String)queue.removeFirst();
                int nh = Integer.parseInt(tmp.split(" ")[0]);
                int nw = Integer.parseInt(tmp.split(" ")[1]);
                int oh = Integer.parseInt(tmp.split(" ")[2]);
                int ow = Integer.parseInt(tmp.split(" ")[3]);
                this.filteredImage.setRGB(nw, nh, this.originalImage.getRGB(ow, oh));
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int n_tmpH = nh + i;
                        int n_tmpW = nw + j;
                        int o_tmpH = oh + i;
                        int o_tmpW = ow + j;
                        if (visited[n_tmpH][n_tmpW]) continue;
                        visited[n_tmpH][n_tmpW] = true;
                        queue.addLast(n_tmpH + " " + n_tmpW + " " + o_tmpH + " " + o_tmpW);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

