/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class NormalizationFilter
implements ImageFilter {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private int blockSize = 5;
    private double GOAL_MEAN = 0.0;
    private double GOAL_VARIANCE = 1.0;
    private int mean;
    private int var;
    private int width;
    private int height;
    private int[][] imageMatrix;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        int j;
        int i;
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        this.imageMatrix = new int[this.width][this.height];
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                this.imageMatrix[i][j] = new Color(this.originalImage.getRGB(i, j)).getRed();
            }
        }
        this.mean = this.calculateMean();
        this.var = this.calculateVariance();
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                double normalizedPixel = 0.0;
                double squareError = 0.0;
                if (this.imageMatrix[i][j] > this.mean) {
                    squareError = (this.imageMatrix[i][j] - this.mean) * (this.imageMatrix[i][j] - this.mean);
                    normalizedPixel = this.GOAL_MEAN + Math.sqrt(this.GOAL_VARIANCE * squareError / (double)this.var);
                } else {
                    squareError = (this.imageMatrix[i][j] - this.mean) * (this.imageMatrix[i][j] - this.mean);
                    normalizedPixel = this.GOAL_MEAN - Math.sqrt(this.GOAL_VARIANCE * squareError / (double)this.var);
                }
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int rgb = (int)(-normalizedPixel);
                int color = ImageUtilities.colorToRGB(alpha, rgb, rgb, rgb);
                this.filteredImage.setRGB(i, j, color);
            }
        }
        return this.filteredImage;
    }

    public int calculateVariance() {
        int var = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                var += (this.imageMatrix[i][j] - this.mean) * (this.imageMatrix[i][j] - this.mean);
            }
        }
        return var / (this.height * this.width * 255);
    }

    public int calculateMean() {
        double mean = 0.0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                mean += (double)this.imageMatrix[i][j];
            }
        }
        return (int)mean / (this.width * this.height);
    }

    public String toString() {
        return "Normalization Filter";
    }

    public void setGOAL_MEAN(double GOAL_MEAN) {
        this.GOAL_MEAN = GOAL_MEAN;
    }

    public void setGOAL_VARIANCE(double GOAL_VARIANCE) {
        this.GOAL_VARIANCE = GOAL_VARIANCE;
    }
}

