/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class MeanFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int radius = 4;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int color = this.findMean(i, j);
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int rgb = ImageUtilities.colorToRGB(alpha, color, color, color);
                this.filteredImage.setRGB(i, j, rgb);
            }
        }
        return this.filteredImage;
    }

    public int findMean(int x, int y) {
        double sum = 0.0;
        int n = 0;
        for (int i = x - this.radius; i <= x + this.radius; ++i) {
            for (int j = y - this.radius; j <= y + this.radius; ++j) {
                if (i <= 0 || i >= this.originalImage.getWidth() || j <= 0 || j >= this.originalImage.getHeight()) continue;
                int color = new Color(this.originalImage.getRGB(i, j)).getRed();
                sum += (double)color;
                ++n;
            }
        }
        return (int)Math.round(sum / (double)n);
    }

    public String toString() {
        return "Mean Filter";
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }
}

