/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class LetterSegmentationFilter
implements ImageFilter {
    private BufferedImage originalImage;
    private int width;
    private int height;
    private boolean[][] visited;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.visited = new boolean[this.width][this.height];
        int name = 1;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int color = new Color(this.originalImage.getRGB(i, j)).getRed();
                if (color == 255) {
                    this.visited[i][j] = true;
                    continue;
                }
                if (name > 3000) {
                    return this.originalImage;
                }
                this.BFS(i, j, name + "");
                ++name;
            }
        }
        return this.originalImage;
    }

    public void BFS(int startI, int startJ, String imageName) {
        LinkedList<String> queue = new LinkedList<String>();
        int letterWidth = 80;
        int letterHeight = 80;
        int gapX = 30;
        int gapY = 30;
        BufferedImage letter = new BufferedImage(letterWidth, letterHeight, 12);
        int alpha = new Color(this.originalImage.getRGB(startI, startJ)).getAlpha();
        int white = ImageUtilities.colorToRGB(alpha, 255, 255, 255);
        int black = ImageUtilities.colorToRGB(alpha, 0, 0, 0);
        for (int i = 0; i < letterWidth; ++i) {
            for (int j = 0; j < letterHeight; ++j) {
                letter.setRGB(i, j, white);
            }
        }
        int count = 0;
        String positions = startI + " " + startJ;
        this.visited[startI][startJ] = true;
        queue.addLast(positions);
        while (!queue.isEmpty()) {
            String pos = (String)queue.removeFirst();
            String[] posArray = pos.split(" ");
            int x = Integer.parseInt(posArray[0]);
            int y = Integer.parseInt(posArray[1]);
            this.visited[x][y] = true;
            int posX = startI - x + gapX;
            int posY = startJ - y + gapY;
            ++count;
            try {
                letter.setRGB(posX, posY, black);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("posX " + posX);
                System.out.println("posY " + posY);
                System.out.println("letterWidth " + letter.getWidth());
                System.out.println("letterHeight " + letter.getHeight());
                throw e;
            }
            for (int i = x - 1; i <= x + 1; ++i) {
                for (int j = y - 1; j <= y + 1; ++j) {
                    int color;
                    if (i < 0 || j < 0 || i >= this.originalImage.getWidth() || j >= this.originalImage.getHeight() || this.visited[i][j] || (color = new Color(this.originalImage.getRGB(i, j)).getRed()) >= 10) continue;
                    this.visited[i][j] = true;
                    String tmpPos = i + " " + j;
                    queue.addLast(tmpPos);
                }
            }
        }
        System.out.println("count = " + count);
        if (count < 3) {
            return;
        }
        try {
            this.saveToFile(letter, imageName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveToFile(BufferedImage img, String name) throws FileNotFoundException, IOException {
        File outputfile = new File("C:/Users/Mihailo/Documents/NetBeansProjects/ImagePreprocessing/Segmented_letters/" + name + ".jpg");
        ImageIO.write((RenderedImage)img, "jpg", outputfile);
    }

    public String toString() {
        return "Letter Segmentation filter";
    }
}

