/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class HistogramEqualizationFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int[] histogram = this.imageHistogram(this.originalImage);
        int[] histogramCumulative = new int[histogram.length];
        histogramCumulative[0] = histogram[0];
        for (int i = 1; i < histogramCumulative.length; ++i) {
            histogramCumulative[i] = histogramCumulative[i - 1] + histogram[i];
        }
        int G = 256;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = (G - 1) * histogramCumulative[gray] / (width * height);
                newColor = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public int[] imageHistogram(BufferedImage image) {
        int i;
        int[] histogram = new int[256];
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int gray;
                int n = gray = new Color(image.getRGB(i, j)).getRed();
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public String toString() {
        return "Histogram Equalization Filter";
    }
}

