/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GenericConvolution
implements ImageFilter {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private double[][] kernel;
    private boolean normalize;

    public GenericConvolution(double[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int radius = this.kernel.length / 2;
        if (this.normalize) {
            this.normalizeKernel();
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double result = this.convolve(x, y, radius);
                int gray = (int)Math.round(result);
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int rgb = ImageUtilities.colorToRGB(alpha, gray, gray, gray);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    protected double convolve(int x, int y, int radius) {
        double sum = 0.0;
        int kernelI = 0;
        for (int i = x - radius; i <= x + radius; ++i) {
            int kernelJ = 0;
            for (int j = y - radius; j <= y + radius; ++j) {
                if (i >= 0 && i < this.originalImage.getWidth() && j > 0 && j < this.originalImage.getHeight()) {
                    int color = new Color(this.originalImage.getRGB(i, j)).getRed();
                    sum += (double)color * this.kernel[kernelI][kernelJ];
                }
                ++kernelJ;
            }
            ++kernelI;
        }
        return sum;
    }

    private void normalizeKernel() {
        int j;
        int i;
        int n = 0;
        for (i = 0; i < this.kernel.length; ++i) {
            for (j = 0; j < this.kernel.length; ++j) {
                n = (int)((double)n + this.kernel[i][j]);
            }
        }
        for (i = 0; i < this.kernel.length; ++i) {
            for (j = 0; j < this.kernel.length; ++j) {
                this.kernel[i][j] = this.kernel[i][j] / (double)n;
            }
        }
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setKernel(double[][] kernel) {
        if (kernel.length % 2 == 0) {
            System.out.println("ERROR!");
        }
        this.kernel = kernel;
    }

    public String toString() {
        return "Generic convolution";
    }
}

