/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval.classification;

public class ConfusionMatrix {
    private String[] classLabels;
    private int[][] values;
    private int classCount;
    private int total = 0;
    private static final int STRING_DEFAULT_WIDTH = 7;

    public ConfusionMatrix(String[] classLabels) {
        this.classLabels = classLabels;
        this.classCount = classLabels.length;
        this.values = new int[this.classCount][this.classCount];
    }

    public int[][] getValues() {
        return this.values;
    }

    public double getValueAt(int actual, int predicted) {
        return this.values[actual][predicted];
    }

    public void incrementElement(int actual, int predicted) {
        int[] nArray = this.values[actual];
        int n = predicted;
        nArray[n] = nArray[n] + 1;
        ++this.total;
    }

    int getClassCount() {
        return this.classCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int maxColumnLenght = 7;
        for (String label : this.classLabels) {
            maxColumnLenght = Math.max(maxColumnLenght, label.length());
        }
        builder.append(String.format("%1$" + maxColumnLenght + "s", ""));
        for (String label : this.classLabels) {
            builder.append(String.format("%1$" + maxColumnLenght + "s", label));
        }
        builder.append("\n");
        for (int i = 0; i < this.values.length; ++i) {
            builder.append(String.format("%1$" + maxColumnLenght + "s", this.classLabels[i]));
            for (int j = 0; j < this.values[0].length; ++j) {
                builder.append(String.format("%1$" + maxColumnLenght + "s", this.values[i][j]));
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public int getTruePositive(int clsIdx) {
        return this.values[clsIdx][clsIdx];
    }

    public int getTrueNegative(int clsIdx) {
        int trueNegative = 0;
        for (int i = 0; i < this.classCount; ++i) {
            if (i == clsIdx) continue;
            for (int j = 0; j < this.classCount; ++j) {
                if (j == clsIdx) continue;
                trueNegative += this.values[i][j];
            }
        }
        return trueNegative;
    }

    public int getFalsePositive(int clsIdx) {
        int falsePositive = 0;
        for (int i = 0; i < this.classCount; ++i) {
            if (i == clsIdx) continue;
            falsePositive += this.values[i][clsIdx];
        }
        return falsePositive;
    }

    public int getFalseNegative(int clsIdx) {
        int falseNegative = 0;
        for (int i = 0; i < this.classCount; ++i) {
            if (i == clsIdx) continue;
            falseNegative += this.values[clsIdx][i];
        }
        return falseNegative;
    }

    public String[] getClassLabels() {
        return this.classLabels;
    }

    public int getTotal() {
        return this.total;
    }

    public int get(int x, int y) {
        return this.values[x][y];
    }
}

