/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval;

import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.eval.classification.ClassificationMetrics;
import org.neuroph.eval.classification.ConfusionMatrix;

public class EvaluationResult {
    ConfusionMatrix confusionMatrix;
    double meanSquareError;
    DataSet dataSet;
    NeuralNetwork neuralNetwork;

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public void setConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
    }

    public ClassificationMetrics[] getClassificationMetricses() {
        return ClassificationMetrics.createFromMatrix(this.confusionMatrix);
    }

    public double getMeanSquareError() {
        return this.meanSquareError;
    }

    public void setMeanSquareError(double meanSquareError) {
        this.meanSquareError = meanSquareError;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public NeuralNetwork getNeuralNetwork() {
        return this.neuralNetwork;
    }

    public void setNeuralNetwork(NeuralNetwork neuralNetwork) {
        this.neuralNetwork = neuralNetwork;
    }

    public String toString() {
        ClassificationMetrics[] cms = this.getClassificationMetricses();
        StringBuilder sb = new StringBuilder();
        for (ClassificationMetrics c : cms) {
            sb.append(c).append("\r\n");
        }
        return "EvaluationResult{dataSet=" + this.dataSet.getLabel() + ", meanSquareError=" + this.meanSquareError + ", \r\n confusionMatrix=\r\n" + this.confusionMatrix + "\r\n" + sb.toString() + "}\r\n";
    }
}

