/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.Properties;

public class Ramp
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double slope = 1.0;
    private double xHigh = 1.0;
    private double xLow = 0.0;
    private double yHigh = 1.0;
    private double yLow = 0.0;

    public Ramp() {
    }

    public Ramp(double slope, double xLow, double xHigh, double yLow, double yHigh) {
        this.slope = slope;
        this.xLow = xLow;
        this.xHigh = xHigh;
        this.yLow = yLow;
        this.yHigh = yHigh;
    }

    public Ramp(Properties properties) {
        try {
            this.slope = (Double)properties.getProperty("transferFunction.slope");
            this.yHigh = (Double)properties.getProperty("transferFunction.yHigh");
            this.yLow = (Double)properties.getProperty("transferFunction.yLow");
            this.xHigh = (Double)properties.getProperty("transferFunction.xHigh");
            this.xLow = (Double)properties.getProperty("transferFunction.xLow");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    @Override
    public double getOutput(double net) {
        if (net < this.xLow) {
            return this.yLow;
        }
        if (net > this.xHigh) {
            return this.yHigh;
        }
        return this.slope * net;
    }

    public double getXLow() {
        return this.xLow;
    }

    public void setXLow(double x) {
        this.xLow = x;
    }

    public double getXHigh() {
        return this.xHigh;
    }

    public void setXHigh(double x) {
        this.xHigh = x;
    }

    public double getYLow() {
        return this.yLow;
    }

    public void setYLow(double y) {
        this.yLow = y;
    }

    public double getYHigh() {
        return this.yHigh;
    }

    public void setYHigh(double y) {
        this.yHigh = y;
    }
}

