/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Weight<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    public double value;
    public transient double weightChange;
    private transient T trainingData;

    public Weight() {
        this.value = Math.random() - 0.5;
        this.weightChange = 0.0;
    }

    public Weight(double value) {
        this.value = value;
    }

    public final void inc(double amount) {
        this.value += amount;
    }

    public final void dec(double amount) {
        this.value -= amount;
    }

    public final void setValue(double value) {
        this.value = value;
    }

    public final double getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Deprecated
    public void randomize(double min, double max) {
        this.value = min + Math.random() * (max - min);
    }

    public final T getTrainingData() {
        return this.trainingData;
    }

    public final void setTrainingData(T trainingData) {
        this.trainingData = trainingData;
    }

    public Object clone() throws CloneNotSupportedException {
        Weight cloned = (Weight)super.clone();
        cloned.setTrainingData(new Object());
        return cloned;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 17).append(this.value).append(this.weightChange).append(this.trainingData).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Weight other = (Weight)obj;
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(other.value)) {
            return false;
        }
        if (Double.doubleToLongBits(this.weightChange) != Double.doubleToLongBits(other.weightChange)) {
            return false;
        }
        return Objects.equals(this.trainingData, other.trainingData);
    }
}

