/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import java.util.Objects;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;

public class Connection
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Neuron fromNeuron;
    protected Neuron toNeuron;
    protected Weight weight;

    public Connection(Neuron fromNeuron, Neuron toNeuron) {
        if (fromNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null !");
        }
        this.fromNeuron = fromNeuron;
        if (toNeuron == null) {
            throw new IllegalArgumentException("To neuron in connection cant be null!");
        }
        this.toNeuron = toNeuron;
        this.weight = new Weight();
    }

    public Connection(Neuron fromNeuron, Neuron toNeuron, Weight weight) {
        this(fromNeuron, toNeuron);
        if (weight == null) {
            throw new IllegalArgumentException("Connection Weight cant be null!");
        }
        this.weight = weight;
    }

    public Connection(Neuron fromNeuron, Neuron toNeuron, double weightVal) {
        this(fromNeuron, toNeuron, new Weight(weightVal));
    }

    public final Weight getWeight() {
        return this.weight;
    }

    public final void setWeight(Weight weight) {
        if (weight == null) {
            throw new IllegalArgumentException("Connection Weight cant be null!");
        }
        this.weight = weight;
    }

    public double getInput() {
        return this.fromNeuron.getOutput();
    }

    public final double getWeightedInput() {
        return this.fromNeuron.getOutput() * this.weight.value;
    }

    public final Neuron getFromNeuron() {
        return this.fromNeuron;
    }

    public final Neuron getToNeuron() {
        return this.toNeuron;
    }

    public Object clone() throws CloneNotSupportedException {
        Connection cloned = (Connection)super.clone();
        cloned.setWeight((Weight)this.weight.clone());
        cloned.toNeuron = (Neuron)this.toNeuron.clone();
        cloned.fromNeuron = (Neuron)this.fromNeuron.clone();
        return cloned;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.fromNeuron);
        hash = 67 * hash + Objects.hashCode(this.toNeuron);
        hash = 67 * hash + Objects.hashCode(this.weight);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        if (!Objects.equals(this.fromNeuron, other.fromNeuron)) {
            return false;
        }
        if (!Objects.equals(this.toNeuron, other.toNeuron)) {
            return false;
        }
        return Objects.equals(this.weight, other.weight);
    }

    public String toString() {
        return "Connection{fromNeuron=" + this.fromNeuron + ", toNeuron=" + this.toNeuron + ", weight=" + this.weight + '}';
    }
}

