/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.matrixmlp;

import org.neuroph.contrib.matrixmlp.MatrixInputLayer;
import org.neuroph.contrib.matrixmlp.MatrixLayer;
import org.neuroph.contrib.matrixmlp.MatrixMlpLayer;
import org.neuroph.contrib.matrixmlp.MatrixMomentumBackpropagation;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.transfer.Tanh;
import org.neuroph.nnet.MultiLayerPerceptron;

public class MatrixMultiLayerPerceptron
extends NeuralNetwork {
    MultiLayerPerceptron sourceNetwork;
    MatrixLayer[] matrixLayers;

    public MatrixMultiLayerPerceptron(MultiLayerPerceptron sourceNetwork) {
        this.sourceNetwork = sourceNetwork;
        this.createMatrixLayers();
        this.setLearningRule(new MatrixMomentumBackpropagation());
    }

    public MatrixLayer[] getMatrixLayers() {
        return this.matrixLayers;
    }

    private void createMatrixLayers() {
        this.matrixLayers = new MatrixLayer[this.sourceNetwork.getLayersCount()];
        this.matrixLayers[0] = new MatrixInputLayer(this.sourceNetwork.getLayerAt(0).getNeuronsCount());
        MatrixLayer prevLayer = this.matrixLayers[0];
        for (int i = 1; i < this.sourceNetwork.getLayersCount(); ++i) {
            Layer layer = this.sourceNetwork.getLayerAt(i);
            MatrixMlpLayer newBpLayer = new MatrixMlpLayer(layer, prevLayer, new Tanh());
            this.matrixLayers[i] = newBpLayer;
            prevLayer = newBpLayer;
        }
    }

    @Override
    public void calculate() {
        for (int i = 1; i < this.matrixLayers.length; ++i) {
            this.matrixLayers[i].calculate();
        }
    }

    @Override
    public void setInput(double ... inputs) {
        this.matrixLayers[0].setInputs(inputs);
    }

    @Override
    public double[] getOutput() {
        return this.matrixLayers[this.matrixLayers.length - 1].getOutputs();
    }

    @Override
    public int getLayersCount() {
        return this.matrixLayers.length;
    }
}

