/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.matrixmlp;

import org.neuroph.contrib.matrixmlp.MatrixInputLayer;
import org.neuroph.contrib.matrixmlp.MatrixLayer;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.transfer.Tanh;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.neuron.BiasNeuron;

public class MatrixMlpLayer
implements MatrixLayer {
    Layer sourceLayer;
    int neuronsCount = 0;
    int inputsCount = 0;
    double[][] weights;
    double[][] deltaWeights;
    boolean useBias;
    double[] inputs;
    double[] netInput;
    double[] outputs;
    double[] errors;
    TransferFunction transferFunction = new Tanh();
    MatrixLayer previousLayer = null;
    MatrixLayer nextLayer = null;

    public MatrixMlpLayer(Layer sourceLayer, MatrixLayer previousLayer, TransferFunction transferFunction) {
        this.sourceLayer = sourceLayer;
        this.previousLayer = previousLayer;
        if (!(previousLayer instanceof MatrixInputLayer)) {
            ((MatrixMlpLayer)previousLayer).setNextLayer(this);
        }
        this.transferFunction = transferFunction;
        this.neuronsCount = sourceLayer.getNeuronsCount();
        this.inputsCount = previousLayer.getOutputs().length;
        this.outputs = new double[this.neuronsCount];
        this.inputs = new double[this.inputsCount];
        this.netInput = new double[this.neuronsCount];
        this.weights = new double[this.neuronsCount][this.inputsCount];
        this.deltaWeights = new double[this.neuronsCount][this.inputsCount];
        this.errors = new double[this.neuronsCount];
        this.copyNeuronsToMatrices();
    }

    public MatrixLayer getPreviousLayer() {
        return this.previousLayer;
    }

    public void setPreviousLayer(MatrixLayer previousLayer) {
        this.previousLayer = previousLayer;
    }

    public MatrixLayer getNextLayer() {
        return this.nextLayer;
    }

    public void setNextLayer(MatrixLayer nextLayer) {
        this.nextLayer = nextLayer;
    }

    public void copyNeuronsToMatrices() {
        int neuronIdx = 0;
        int connIdx = 0;
        for (Neuron neuron : this.sourceLayer.getNeurons()) {
            if (neuron instanceof BiasNeuron) {
                this.useBias = true;
            }
            this.outputs[neuronIdx] = neuron.getOutput();
            connIdx = 0;
            for (Connection conn : neuron.getInputConnections()) {
                this.weights[neuronIdx][connIdx] = conn.getWeight().getValue();
                ++connIdx;
            }
            ++neuronIdx;
        }
    }

    public void copyMatricesToNeurons() {
    }

    @Override
    public double[] getInputs() {
        return this.inputs;
    }

    @Override
    public double[] getOutputs() {
        return this.outputs;
    }

    @Override
    public void setInputs(double[] inputs) {
        this.inputs = inputs;
    }

    @Override
    public void setOutputs(double[] outputs) {
        this.outputs = outputs;
    }

    public double[][] getWeights() {
        return this.weights;
    }

    public void getInputsFromPreviousLayer() {
        this.inputs = this.previousLayer.getOutputs();
    }

    @Override
    public final void calculate() {
        this.inputs = this.previousLayer.getOutputs();
        for (int i = 0; i < this.neuronsCount; ++i) {
            this.netInput[i] = 0.0;
            for (int j = 0; j < this.inputs.length; ++j) {
                int n = i;
                this.netInput[n] = this.netInput[n] + this.inputs[j] * this.weights[i][j];
            }
            this.outputs[i] = this.transferFunction.getOutput(this.netInput[i]);
        }
        if (this.useBias) {
            this.outputs[this.neuronsCount - 1] = 1.0;
        }
    }

    public int getNeuronsCount() {
        return this.outputs.length;
    }

    public double[] getErrors() {
        return this.errors;
    }

    public void setErrors(double[] errors) {
        this.errors = errors;
    }

    public TransferFunction getTransferFunction() {
        return this.transferFunction;
    }

    public double[] getNetInput() {
        return this.netInput;
    }

    public void saveCurrentWeights() {
        System.arraycopy(this.weights, 0, this.deltaWeights, 0, this.weights.length);
    }

    public double[][] getDeltaWeights() {
        return this.deltaWeights;
    }

    public void sync() {
    }
}

