/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.graphml;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.neuroph.contrib.graphml.ExampleNetworXOR;
import org.neuroph.contrib.graphml.Graph;
import org.neuroph.contrib.graphml.Graphml;
import org.neuroph.contrib.graphml.XMLElement;
import org.neuroph.contrib.graphml.XMLHeader;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.comp.neuron.InputNeuron;

public class GraphmlExport {
    private NeuralNetwork ann;
    private XMLElement graphml;

    public GraphmlExport(NeuralNetwork ann) {
        this.ann = ann;
        this.labelUnmarkedNeurons(this.ann);
    }

    public void parse() {
        this.graphml = new Graphml();
        this.graphml.appendChild(this.createGraph(this.ann));
    }

    public void writeToFile(String filePathOut) {
        try {
            File file = new File(filePathOut);
            file.createNewFile();
            this.print(new PrintStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printToStdout() {
        this.print(System.out);
    }

    private void print(PrintStream out) {
        out.println(XMLHeader.getHeader());
        out.println(this.graphml);
    }

    private Graph createGraph(NeuralNetwork ann) {
        String id = ann.getLabel();
        if (id == null || id.length() == 0) {
            id = "defaultId";
        }
        Graph graph = new Graph(id);
        graph.addNetwork(ann);
        return graph;
    }

    private void labelUnmarkedNeurons(NeuralNetwork ann) {
        for (int layer = 0; layer < ann.getLayersCount(); ++layer) {
            int neuronCount = 0;
            for (Neuron neuron : ann.getLayerAt(layer).getNeurons()) {
                this.labelNeuron(layer, neuronCount, neuron);
                ++neuronCount;
            }
        }
    }

    private void labelNeuron(int layer, int neuronCount, Neuron neuron) {
        if (neuron.getLabel() == null) {
            if (neuron.getClass() == InputNeuron.class) {
                neuron.setLabel("Input-" + neuronCount);
            } else if (neuron.getClass() == BiasNeuron.class) {
                neuron.setLabel("L" + layer + "-bias");
            } else {
                neuron.setLabel("L" + layer + "-" + neuronCount);
            }
        }
    }

    public NeuralNetwork getNeuralNetwork() {
        return this.ann;
    }

    public XMLElement getGraphml() {
        return this.graphml;
    }

    public static void main(String[] args) throws IOException {
        GraphmlExport ge = new GraphmlExport(ExampleNetworXOR.getNetwork());
        ge.parse();
        ge.printToStdout();
    }
}

