/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.neuroph.contrib.bpbench.TrainingSettings;

public class TrainingSettingsGenerator {
    private double minLearningRate;
    private double maxLearningRate;
    private double learningRateStep;
    private int minHiddenNeurons;
    private int maxHiddenNeurons;
    private int hiddenNeuronsStep;
    private double momentum;
    private double maxError;
    private int maxIterations;
    private boolean batchMode;
    private double decreaseFactor;
    private double increaseFactor;
    private double initialDelta;
    private double maxDelta;
    private double minDelta;
    private Properties settings;

    public TrainingSettingsGenerator() {
        this.settings = new Properties();
    }

    public TrainingSettingsGenerator(double minLearningRate, double maxLearningRate, double learningRateStep, int minHiddenNeurons, int maxHiddenNeurons, int hiddenNeuronsStep, double momentum, double maxError, int maxIterations, boolean batchMode) {
        this.minLearningRate = minLearningRate > 0.0 ? minLearningRate : 0.1;
        this.maxLearningRate = maxLearningRate > 0.0 && maxLearningRate > minLearningRate ? maxLearningRate : 1.0;
        this.learningRateStep = learningRateStep > 0.0 && learningRateStep < 1.0 ? learningRateStep : 0.1;
        this.minHiddenNeurons = minHiddenNeurons > 0 ? minHiddenNeurons : 1;
        this.maxHiddenNeurons = maxHiddenNeurons > 0 && maxHiddenNeurons > minHiddenNeurons ? maxHiddenNeurons : 10;
        this.hiddenNeuronsStep = hiddenNeuronsStep > 0 ? hiddenNeuronsStep : 1;
        this.momentum = momentum;
        this.maxError = maxError;
        this.maxIterations = maxIterations;
        this.batchMode = batchMode;
    }

    public List<TrainingSettings> generateSettings() {
        ArrayList<TrainingSettings> list = new ArrayList<TrainingSettings>();
        double learningRateStart = this.minLearningRate;
        int hiddenNeuronStart = this.minHiddenNeurons;
        for (double i = learningRateStart; i < this.maxLearningRate; i += this.learningRateStep) {
            for (int j = hiddenNeuronStart; j < this.maxHiddenNeurons; j += this.hiddenNeuronsStep) {
                list.add(new TrainingSettings(i, this.momentum, j, this.maxIterations, this.maxError, this.batchMode));
            }
        }
        return list;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public void setSettings(Properties settings) {
        this.settings = settings;
        this.setUpGenerator();
    }

    private void setUpGenerator() {
        this.batchMode = Boolean.parseBoolean(this.settings.getProperty("batchMode", "false"));
        this.hiddenNeuronsStep = Integer.parseInt(this.settings.getProperty("hiddenNeuronsStep", "1"));
        this.learningRateStep = Double.parseDouble(this.settings.getProperty("learningRateStep", "0.1"));
        this.maxError = Double.parseDouble(this.settings.getProperty("maxError", "0.03"));
        this.maxHiddenNeurons = Integer.parseInt(this.settings.getProperty("maxHiddenNeurons", "1"));
        this.maxIterations = Integer.parseInt(this.settings.getProperty("maxIterations", "10000"));
        this.maxLearningRate = Double.parseDouble(this.settings.getProperty("maxLearningRate", "1"));
        this.minHiddenNeurons = Integer.parseInt(this.settings.getProperty("minHiddenNeurons", "0"));
        this.minLearningRate = Double.parseDouble(this.settings.getProperty("minLearningRate", "0.001"));
        this.momentum = Double.parseDouble(this.settings.getProperty("momentum", "0.3"));
        this.decreaseFactor = Double.parseDouble(this.settings.getProperty("decreaseFactor", "0.5"));
        this.increaseFactor = Double.parseDouble(this.settings.getProperty("increaseFactor", "1.2"));
        this.initialDelta = Double.parseDouble(this.settings.getProperty("initialDelta", "0.1"));
        this.maxDelta = Double.parseDouble(this.settings.getProperty("maxDelta", "1.0"));
        this.minDelta = Double.parseDouble(this.settings.getProperty("minDelta", "1e-6"));
    }
}

