/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.autotrain;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.neuroph.contrib.autotrain.AutoTrainer;
import org.neuroph.contrib.autotrain.TrainingResult;

public class Util {
    private static final String FILENAME = "result.csv";

    public static void saveToCSV(AutoTrainer trainer, List<TrainingResult> results) throws FileNotFoundException {
        System.out.println("Creating 'result.csv'...");
        StringBuilder sb = new StringBuilder();
        boolean split = trainer.isSplitForTesting();
        boolean stat = trainer.generatesStatistics();
        sb.append("Learning rate, Hidden Neurons, Momentum, Max Error, ");
        boolean pom = true;
        if (split) {
            sb.append("Training Set(%), Test Set(%), ");
        }
        if (stat) {
            sb.append("Min Iterations, Max Iterations,Mean Iterations,STD Iterations, Min MSE,Max MSE,Mean MSE,STD MSE,");
            pom = false;
        }
        if (pom) {
            sb.append("Iterations, Total error, ");
        }
        sb.append("\n");
        for (TrainingResult tr : results) {
            double lr = tr.getSettings().getLearningRate();
            int hidden = tr.getSettings().getHiddenNeurons();
            double momentum = tr.getSettings().getMomentum();
            double error = tr.getSettings().getMaxError();
            sb.append(lr);
            sb.append(',');
            sb.append(hidden);
            sb.append(',');
            sb.append(momentum);
            sb.append(',');
            sb.append(error);
            sb.append(',');
            if (split) {
                sb.append(tr.getSettings().getTrainingSet());
                sb.append(',');
                sb.append(tr.getSettings().getTestSet());
                sb.append(',');
            }
            if (stat) {
                sb.append(tr.getIterationStat().getMin());
                sb.append(',');
                sb.append(tr.getIterationStat().getMax());
                sb.append(',');
                sb.append(tr.getIterationStat().getMean());
                sb.append(',');
                sb.append(tr.getIterationStat().getStd());
                sb.append(',');
                sb.append(new BigDecimal(tr.getMSE().getMin()).setScale(8, RoundingMode.HALF_UP));
                sb.append(',');
                sb.append(new BigDecimal(tr.getMSE().getMax()).setScale(8, RoundingMode.HALF_UP));
                sb.append(',');
                sb.append(new BigDecimal(tr.getMSE().getMean()).setScale(8, RoundingMode.HALF_UP));
                sb.append(',');
                sb.append(new BigDecimal(tr.getMSE().getStd()).setScale(8, RoundingMode.HALF_UP));
                sb.append(',');
            }
            if (pom) {
                sb.append(tr.getIterations());
                sb.append(',');
                sb.append(tr.getTotalError());
                sb.append(',');
            }
            sb.append('\n');
        }
        try (PrintWriter pw = new PrintWriter(new File(FILENAME));){
            pw.write(sb.toString());
        }
        System.out.println("'result.csv' successfully created.");
    }
}

