/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.learning.UnsupervisedHebbianLearning;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class RecommenderNetwork
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;
    int inputLayerIdx = 0;
    int typeLayerIdx = 1;
    int brandLayerIdx = 2;
    int priceLayerIdx = 3;
    int promoLayerIdx = 4;
    int outputLayerIdx = 5;

    public void createDemoNetwork() {
        int productsCount = 20;
        int typesCount = 3;
        int brandsCount = 3;
        int priceCount = 3;
        int promoCount = 3;
        this.setNetworkType(NeuralNetworkType.RECOMMENDER);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.RAMP);
        neuronProperties.setProperty("transferFunction.slope", new Double(1.0));
        Layer inputLayer = LayerFactory.createLayer(productsCount, neuronProperties);
        this.addLayer(inputLayer);
        this.createProductLabels(inputLayer);
        Layer typeLayer = LayerFactory.createLayer(typesCount, neuronProperties);
        this.createTypeLabels(typeLayer);
        this.addLayer(typeLayer);
        Layer brandLayer = LayerFactory.createLayer(brandsCount, neuronProperties);
        this.createBrandLabels(brandLayer);
        this.addLayer(brandLayer);
        Layer priceLayer = LayerFactory.createLayer(priceCount, neuronProperties);
        this.createPriceLabels(priceLayer);
        this.addLayer(priceLayer);
        Layer promoLayer = LayerFactory.createLayer(promoCount, neuronProperties);
        this.createPromoLabels(promoLayer);
        this.addLayer(promoLayer);
        Layer outputLayer = LayerFactory.createLayer(productsCount, neuronProperties);
        this.addLayer(outputLayer);
        this.createProductLabels(outputLayer);
        this.createTypeConnections();
        this.createBrandConnections();
        this.createPriceConnections();
        this.createPromoConnections();
        for (Neuron neuron : this.getLayerAt(this.outputLayerIdx).getNeurons()) {
            neuron.addInputConnection(neuron, 1.0);
        }
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new UnsupervisedHebbianLearning());
    }

    private void createTypeConnections() {
        Neuron toNeuron;
        Neuron fromNeuron;
        int i;
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(i);
            toNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(0);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 7; i < 14; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(i);
            toNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(1);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 14; i < 20; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(i);
            toNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(2);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(0);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(i);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 7; i < 14; ++i) {
            fromNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(1);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(i);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 14; i < 20; ++i) {
            fromNeuron = this.getLayerAt(this.typeLayerIdx).getNeuronAt(2);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(i);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
    }

    private void createBrandConnections() {
        Neuron toNeuron;
        Neuron fromNeuron;
        int i;
        int[] samsung = new int[]{0, 1, 7, 8, 9, 14, 15};
        int[] lg = new int[]{2, 3, 10, 11, 16, 17};
        int[] sony = new int[]{4, 5, 6, 12, 13, 18, 19};
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(samsung[i]);
            toNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(0);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 6; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(lg[i]);
            toNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(1);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(sony[i]);
            toNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(2);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(0);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(samsung[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 6; ++i) {
            fromNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(1);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(lg[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.brandLayerIdx).getNeuronAt(2);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(sony[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
    }

    private void createPriceConnections() {
        Neuron toNeuron;
        Neuron fromNeuron;
        int i;
        int[] low = new int[]{0, 2, 4, 7, 10, 16, 18};
        int[] mid = new int[]{3, 5, 8, 11, 12, 14, 19};
        int[] high = new int[]{1, 6, 9, 13, 15, 17};
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(low[i]);
            toNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(0);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(mid[i]);
            toNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(1);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 6; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(high[i]);
            toNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(2);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(0);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(low[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 7; ++i) {
            fromNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(1);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(mid[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < 6; ++i) {
            fromNeuron = this.getLayerAt(this.priceLayerIdx).getNeuronAt(2);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(high[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
    }

    private void createPromoConnections() {
        Neuron toNeuron;
        Neuron fromNeuron;
        int i;
        int[] sales = new int[]{0, 10, 19};
        int[] new_products = new int[]{6, 9};
        int[] bestsellers = new int[]{3, 12, 14};
        for (i = 0; i < sales.length; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(sales[i]);
            toNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(0);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < new_products.length; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(new_products[i]);
            toNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(1);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < bestsellers.length; ++i) {
            fromNeuron = this.getLayerAt(this.inputLayerIdx).getNeuronAt(bestsellers[i]);
            toNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(2);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < sales.length; ++i) {
            fromNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(0);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(sales[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < new_products.length; ++i) {
            fromNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(1);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(new_products[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
        for (i = 0; i < bestsellers.length; ++i) {
            fromNeuron = this.getLayerAt(this.promoLayerIdx).getNeuronAt(2);
            toNeuron = this.getLayerAt(this.outputLayerIdx).getNeuronAt(bestsellers[i]);
            this.createConnection(fromNeuron, toNeuron, 0.1);
        }
    }

    private void createProductLabels(Layer layer) {
        layer.getNeuronAt(0).setLabel("Samsung LCD TV LE-32A330");
        layer.getNeuronAt(1).setLabel("Samsung LCD TV LE-32A558");
        layer.getNeuronAt(2).setLabel("LG LCD TV 32LG2000");
        layer.getNeuronAt(3).setLabel("LG LCD TV 32LG5010");
        layer.getNeuronAt(4).setLabel("Sony LCD TV KDL-32L4000K");
        layer.getNeuronAt(5).setLabel("Sony LCD TV KDL-32S4000");
        layer.getNeuronAt(6).setLabel("Sony LCD TV KDL-32W4000K");
        layer.getNeuronAt(7).setLabel("Samsung Digital Camera S760");
        layer.getNeuronAt(8).setLabel("Samsung Digital Camera L100");
        layer.getNeuronAt(9).setLabel("Samsung Digital Camera S850");
        layer.getNeuronAt(10).setLabel("LG Digital Camera DMCLS80E");
        layer.getNeuronAt(11).setLabel("LG Digital Camera DMCLZ8E");
        layer.getNeuronAt(12).setLabel("Sony Digital Camera DSCW120S");
        layer.getNeuronAt(13).setLabel("Sony Digital Camera DSCW130S");
        layer.getNeuronAt(14).setLabel("Samsung Mobile Phone E251");
        layer.getNeuronAt(15).setLabel("Samsung Mobile Phone U600");
        layer.getNeuronAt(16).setLabel("Sony Mobile Phone KP100");
        layer.getNeuronAt(17).setLabel("Sony Mobile Phone KE850");
        layer.getNeuronAt(18).setLabel("LG Mobile Phone K330");
        layer.getNeuronAt(19).setLabel("LG Mobile Phone K660");
    }

    private void createTypeLabels(Layer layer) {
        layer.getNeuronAt(0).setLabel("LCD TV");
        layer.getNeuronAt(1).setLabel("Digital Camera");
        layer.getNeuronAt(2).setLabel("Mobile Phone");
    }

    private void createBrandLabels(Layer layer) {
        layer.getNeuronAt(0).setLabel("Samsung");
        layer.getNeuronAt(1).setLabel("LG");
        layer.getNeuronAt(2).setLabel("Sony");
    }

    private void createPriceLabels(Layer layer) {
        layer.getNeuronAt(0).setLabel("Low Price");
        layer.getNeuronAt(1).setLabel("Mid Price");
        layer.getNeuronAt(2).setLabel("High Price");
    }

    private void createPromoLabels(Layer layer) {
        layer.getNeuronAt(0).setLabel("Sales");
        layer.getNeuronAt(1).setLabel("New");
        layer.getNeuronAt(2).setLabel("Bestseller");
    }
}

