/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.adapters.weka;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaDataSetConverter {
    public static DataSet convertWekaToNeurophDataset(Instances wekaDataset, int numInputs, int numOutputs) {
        if (numInputs <= 0) {
            throw new IllegalArgumentException("Number of inputs  in DataSet cannot be zero or negative!");
        }
        if (numOutputs < 0) {
            throw new IllegalArgumentException("Number of outputs  in DataSet cannot be negative!");
        }
        if (numOutputs + numInputs < wekaDataset.numAttributes()) {
            throw new IllegalArgumentException("Number of outputs and inputs should be equal to number of attributes from data set!");
        }
        DataSet neurophDataset = null;
        neurophDataset = numOutputs > 0 ? new DataSet(numInputs, numOutputs) : new DataSet(numInputs);
        ArrayList<Double> classValues = new ArrayList<Double>();
        for (Instance inst : wekaDataset) {
            Double classDouble = inst.classValue();
            if (classValues.contains(classDouble)) continue;
            classValues.add(classDouble);
        }
        Enumeration en = wekaDataset.enumerateInstances();
        while (en.hasMoreElements()) {
            int k;
            Instance instance = (Instance)en.nextElement();
            double[] values = instance.toDoubleArray();
            if (numOutputs == 0) {
                neurophDataset.addRow(values);
                continue;
            }
            double[] inputs = new double[numInputs];
            double[] outputs = new double[numOutputs];
            for (k = 0; k < values.length; ++k) {
                if (k >= numInputs) continue;
                inputs[k] = values[k];
            }
            k = 0;
            for (Double entry : classValues) {
                outputs[k] = entry.doubleValue() == instance.classValue() ? 1.0 : 0.0;
                ++k;
            }
            DataSetRow row = new DataSetRow(inputs, outputs);
            row.setLabel(instance.stringValue(instance.classIndex()));
            neurophDataset.addRow(row);
        }
        return neurophDataset;
    }

    public static Instances convertNeurophToWekaDataset(DataSet neurophDataset) {
        Map<double[], String> classValues = WekaDataSetConverter.getClassValues(neurophDataset);
        Instances instances = WekaDataSetConverter.createEmptyWekaDataSet(neurophDataset.getInputSize(), neurophDataset.size(), classValues);
        int numInputs = neurophDataset.getInputSize();
        int numOutputs = 1;
        instances.setClassIndex(numInputs);
        for (DataSetRow row : neurophDataset) {
            DenseInstance instance;
            if (numOutputs > 0) {
                instance = new DenseInstance(numInputs + numOutputs);
                for (int i = 0; i < numInputs; ++i) {
                    instance.setValue(i, row.getInput()[i]);
                }
                instance.setDataset(instances);
                for (Map.Entry<double[], String> entry : classValues.entrySet()) {
                    if (!entry.getValue().equals(row.getLabel())) continue;
                    instance.setValue(numInputs, entry.getValue());
                    double[] rowDouble = row.getDesiredOutput();
                    int i = 0;
                    if (i >= rowDouble.length || rowDouble[i] != 1.0) break;
                    instance.setValue(numInputs, (double)i);
                    break;
                }
                instances.add((Instance)instance);
                continue;
            }
            instance = new DenseInstance(numInputs);
            for (int i = 0; i < numInputs; ++i) {
                instance.setValue(i, row.getInput()[i]);
            }
            instance.setDataset(instances);
            instances.add((Instance)instance);
        }
        return instances;
    }

    private static Instances createEmptyWekaDataSet(int numOfAttr, int capacity, Map<double[], String> classValues) {
        FastVector fvClassVal = new FastVector();
        HashMap<String, Double> classVals = new HashMap<String, Double>();
        HashMap<Double, String> classValsDoubleAsKey = new HashMap<Double, String>();
        int ind = 0;
        for (Map.Entry<double[], String> values : classValues.entrySet()) {
            fvClassVal.addElement((Object)values.getValue());
            classVals.put(values.getValue(), new Double(ind));
            classValsDoubleAsKey.put(new Double(ind), values.getValue());
            ++ind;
        }
        Attribute classAttribute = new Attribute("theClass", (List)fvClassVal, classValues.size());
        FastVector fvWekaAttributes = new FastVector(numOfAttr + 1);
        for (int i = 0; i < numOfAttr; ++i) {
            fvWekaAttributes.addElement((Object)new Attribute(i + "", i));
        }
        fvWekaAttributes.addElement((Object)classAttribute);
        Instances newDataSet = new Instances("newDataSet", (ArrayList)fvWekaAttributes, capacity);
        return newDataSet;
    }

    private static Map<double[], String> getClassValues(DataSet neurophDataset) {
        HashMap<double[], String> classValues = new HashMap<double[], String>();
        for (DataSetRow row : neurophDataset.getRows()) {
            if (classValues.containsValue(row.getLabel())) continue;
            classValues.put(row.getDesiredOutput(), row.getLabel());
        }
        return classValues;
    }

    public static DataSet createDataSetFromFile(String filePath, int numInputs) throws Exception {
        return WekaDataSetConverter.createDataSetFromFile(filePath, numInputs, 0);
    }

    public static DataSet createDataSetFromFile(String filePath, int numInputs, int numOutputs) {
        try {
            ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(filePath);
            Instances wekaDataset = dataSource.getDataSet();
            wekaDataset.setClassIndex(numInputs);
            DataSet neurophDataset = WekaDataSetConverter.convertWekaToNeurophDataset(wekaDataset, numInputs, numOutputs);
            return neurophDataset;
        }
        catch (Exception e) {
            return new DataSet(0);
        }
    }
}

