/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AScalar;
import mikera.vectorz.Op;
import mikera.vectorz.impl.AWrappedVector;
import mikera.vectorz.util.ErrorMessages;

public class WrappedScalarVector
extends AWrappedVector<AScalar> {
    private static final long serialVersionUID = 1912695454407729415L;
    public final AScalar scalar;

    public WrappedScalarVector(AScalar s) {
        super(1);
        this.scalar = s;
    }

    @Override
    public boolean isMutable() {
        return this.scalar.isMutable();
    }

    @Override
    public boolean isFullyMutable() {
        return this.scalar.isFullyMutable();
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public AScalar getComponent(int k) {
        if (k != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidComponent(this, k));
        }
        return this.scalar;
    }

    @Override
    public void multiply(double factor) {
        this.scalar.multiply(factor);
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        return this.scalar.get();
    }

    @Override
    public boolean isBoolean() {
        return this.scalar.isBoolean();
    }

    @Override
    public boolean isZero() {
        return this.scalar.isZero();
    }

    @Override
    public double unsafeGet(int i) {
        return this.scalar.get();
    }

    @Override
    public void set(int i, double value) {
        this.checkIndex(i);
        this.scalar.set(value);
    }

    @Override
    public void applyOp(Op op) {
        this.scalar.applyOp(op);
    }

    @Override
    public double elementSum() {
        return this.scalar.get();
    }

    @Override
    public double elementSquaredSum() {
        double x = this.scalar.get();
        return x * x;
    }

    @Override
    public double elementMax() {
        return this.scalar.get();
    }

    @Override
    public double elementMin() {
        return this.scalar.get();
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return data[offset] * this.scalar.get();
    }

    @Override
    public WrappedScalarVector exactClone() {
        return new WrappedScalarVector(this.scalar.exactClone());
    }

    @Override
    public void addAt(int i, double v) {
        this.scalar.add(v);
    }

    @Override
    public double dotProduct(double[] data, int offset, int stride) {
        return data[offset] * this.scalar.get();
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        return this.scalar.get() == data[offset];
    }
}

