/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.ASizedVector;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.IndexedArrayVector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AArrayVector
extends ASizedVector {
    private static final long serialVersionUID = -6271828303431809681L;
    protected final double[] data;

    protected AArrayVector(int length, double[] data) {
        super(length);
        this.data = data;
    }

    @Override
    public AScalar slice(int i) {
        this.checkIndex(i);
        return ArrayIndexScalar.wrap(this.data, this.index(i));
    }

    @Override
    public AVector selectView(int ... indices) {
        if (this.isFullyMutable()) {
            int len = indices.length;
            int[] ixs = new int[len];
            for (int i = 0; i < len; ++i) {
                ixs[i] = this.index(indices[i]);
            }
            return IndexedArrayVector.wrap(this.data, ixs);
        }
        return super.select(indices);
    }

    protected abstract int index(int var1);

    @Override
    public double maxAbsElement() {
        int len = this.length();
        if (len == 0) {
            throw new IllegalArgumentException(ErrorMessages.noElements(this));
        }
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = Math.abs(this.unsafeGet(i));
            if (!(v > result)) continue;
            result = v;
        }
        return result;
    }
}

