/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.INDArray;
import mikera.indexz.AIndex;
import mikera.indexz.Index;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.GrowableVector;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class Vector
extends ADenseArrayVector {
    private static final long serialVersionUID = 6283741614665875877L;
    public static final Vector EMPTY = Vector.wrap(DoubleArrays.EMPTY);

    private Vector(double ... values) {
        super(values.length, values);
    }

    private Vector(int length) {
        this(new double[length]);
    }

    public Vector(AVector source) {
        this(source.toDoubleArray());
    }

    public static Vector wrap(double[] source) {
        return new Vector(source);
    }

    public static Vector create(double[] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return Vector.wrap((double[])data.clone());
    }

    public static Vector create(ArrayList<Number> al) {
        int n = al.size();
        Vector v = Vector.createLength(n);
        for (int i = 0; i < n; ++i) {
            v.unsafeSet(i, al.get(i).doubleValue());
        }
        return v;
    }

    public static Vector create(List<Number> al) {
        int n = al.size();
        Vector v = Vector.createLength(n);
        for (int i = 0; i < n; ++i) {
            v.unsafeSet(i, al.get(i).doubleValue());
        }
        return v;
    }

    public static Vector create(Iterable<Number> iterable) {
        GrowableVector v = GrowableVector.create(iterable);
        return v.toVector();
    }

    public static Vector create(Iterator<Number> iterator) {
        GrowableVector v = GrowableVector.create(iterator);
        return v.toVector();
    }

    public static Vector create(Object o) {
        if (o instanceof AVector) {
            return Vector.create((AVector)o);
        }
        if (o instanceof List) {
            return Vector.create((List)o);
        }
        if (o.getClass().isArray()) {
            return Vector.create((List)o);
        }
        if (o instanceof Iterable) {
            return Vector.create((Iterable)o);
        }
        if (o instanceof Iterator) {
            return Vector.create((Iterator)o);
        }
        Class<?> ec = o.getClass().getComponentType();
        if (ec != null && ec.isPrimitive() && ec == Double.TYPE) {
            return Vector.create((double[])o);
        }
        throw new IllegalArgumentException(ErrorMessages.cantCreateVector(o));
    }

    public static Vector create(double[] data, int start, int length) {
        return Vector.wrap(DoubleArrays.copyOf(data, start, length));
    }

    public static Vector createFromVector(AVector source, int length) {
        Vector v = Vector.createLength(length);
        int n = Math.min(length, source.length());
        source.copyTo(0, v.data, 0, n);
        return v;
    }

    public static Vector of(double ... values) {
        return Vector.create(values);
    }

    public static Vector createLength(int length) {
        if (length < 1) {
            if (length < 0) {
                throw new IllegalArgumentException(ErrorMessages.illegalSize(length));
            }
            return EMPTY;
        }
        return new Vector(length);
    }

    public static Vector create(AVector a) {
        return new Vector(a.toDoubleArray());
    }

    public static Vector create(INDArray a) {
        return new Vector(a.toDoubleArray());
    }

    public static Vector create(AIndex a) {
        int n = a.length();
        Vector v = Vector.createLength(n);
        for (int i = 0; i < n; ++i) {
            v.unsafeSet(i, a.get(i));
        }
        return v;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public void set(AVector a) {
        if (a instanceof Vector) {
            if (a == this) {
                return;
            }
            Vector v = (Vector)a;
            System.arraycopy(v.data, 0, this.data, 0, this.data.length);
        } else {
            super.set(a);
        }
    }

    @Override
    public void getElements(double[] data, int offset, int[] indices) {
        int n = indices.length;
        for (int i = 0; i < n; ++i) {
            data[offset + i] = this.data[indices[i]];
        }
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data, 0, this.data.length);
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void clamp(double min, double max) {
        DoubleArrays.clamp(this.data, min, max);
    }

    @Override
    public void square() {
        DoubleArrays.square(this.data);
    }

    @Override
    public void tanh() {
        DoubleArrays.tanh(this.data);
    }

    @Override
    public void logistic() {
        DoubleArrays.logistic(this.data);
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data);
    }

    @Override
    public double elementMax() {
        return DoubleArrays.elementMax(this.data);
    }

    @Override
    public double elementMin() {
        return DoubleArrays.elementMin(this.data);
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data);
    }

    @Override
    public void signum() {
        DoubleArrays.signum(this.data);
    }

    @Override
    public void abs() {
        DoubleArrays.abs(this.data);
    }

    @Override
    public void add(ADenseArrayVector src, int srcOffset) {
        int length = this.length();
        assert (srcOffset >= 0);
        assert (srcOffset + length <= src.length());
        double[] srcData = src.getArray();
        int relativeOffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + srcData[relativeOffset + i];
        }
    }

    @Override
    public void addMultiple(ADenseArrayVector v, double factor) {
        this.checkSameLength(v);
        v.addMultipleToArray(factor, this.data, 0);
    }

    @Override
    public void add(AVector v) {
        this.checkSameLength(v);
        v.addToArray(this.data, 0);
    }

    @Override
    public void add(double[] srcData, int srcOffset) {
        DoubleArrays.add(srcData, srcOffset, this.data, 0, this.length);
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        for (int i = 0; i < this.length; ++i) {
            this.data[i] = factor * this.data[i] + constant;
        }
    }

    @Override
    public void add(double constant) {
        DoubleArrays.add(this.data, constant);
    }

    @Override
    public void addProduct(AVector a, AVector b) {
        if (a instanceof Vector && b instanceof Vector) {
            this.addProduct((Vector)a, (Vector)b);
            return;
        }
        super.addProduct(a, b);
    }

    public void addProduct(Vector a, Vector b) {
        int length = this.checkSameLength(a, b);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + a.data[i] * b.data[i];
        }
    }

    public void addProduct(Vector a, Vector b, double factor) {
        int length = this.checkSameLength(a, b);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + a.data[i] * b.data[i] * factor;
        }
    }

    @Override
    public void addAt(int i, double v) {
        int n = i;
        this.data[n] = this.data[n] + v;
    }

    @Override
    public void sub(AVector v) {
        if (v instanceof ADenseArrayVector) {
            this.sub((ADenseArrayVector)v);
            return;
        }
        int length = this.checkSameLength(v);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - v.unsafeGet(i);
        }
    }

    @Override
    public double dotProduct(AVector v, Index ix) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v, ix);
        }
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.unsafeGet(i);
        }
        return result;
    }

    public double dotProduct(Vector v, Index ix) {
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.data[i];
        }
        return result;
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.data[i] * data[offset + i];
        }
        return result;
    }

    @Override
    public Vector multiplyCopy(double factor) {
        return Vector.wrap(DoubleArrays.multiplyCopy(this.data, factor));
    }

    public double distanceSquared(Vector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.data[i] - v.data[i];
            total += d * d;
        }
        return total;
    }

    @Override
    public double distance(AVector v) {
        if (v instanceof Vector) {
            return Math.sqrt(this.distanceSquared((Vector)v));
        }
        return super.distance(v);
    }

    public void sub(ADenseArrayVector v) {
        this.sub(v, 0);
    }

    public void sub(ADenseArrayVector src, int srcOffset) {
        int length = this.length();
        assert (length == src.length());
        double[] srcData = src.getArray();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - srcData[voffset + i];
        }
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        this.checkSameLength(v);
        v.addMultipleToArray(factor, this.data, 0);
    }

    @Override
    public void addMultiple(Vector source, Index index, double factor) {
        int len = source.length();
        if (index.length() != len) {
            throw new VectorzException(ErrorMessages.incompatibleShapes(index, source));
        }
        for (int i = 0; i < len; ++i) {
            int j;
            int n = j = index.data[i];
            this.data[n] = this.data[n] + source.data[i] * factor;
        }
    }

    @Override
    public void multiply(double factor) {
        DoubleArrays.multiply(this.data, factor);
    }

    @Override
    public void multiply(AVector v) {
        if (v instanceof Vector) {
            this.multiply((Vector)v);
            return;
        }
        this.checkSameLength(v);
        v.multiplyTo(this.data, 0);
    }

    public void multiply(Vector v) {
        this.checkSameLength(v);
        DoubleArrays.multiply(this.data, v.data);
    }

    @Override
    public void divide(AVector v) {
        if (v instanceof Vector) {
            this.divide((Vector)v);
            return;
        }
        this.checkSameLength(v);
        v.divideTo(this.data, 0);
    }

    public void divide(Vector v) {
        int len = this.checkSameLength(v);
        for (int i = 0; i < len; ++i) {
            this.data[i] = this.data[i] / v.data[i];
        }
    }

    @Override
    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public Vector clone() {
        return Vector.wrap(DoubleArrays.copyOf(this.data));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode(this.data[i]);
        }
        return hashCode;
    }

    @Override
    public Vector ensureMutable() {
        return this;
    }

    @Override
    public Vector exactClone() {
        return this.clone();
    }

    @Override
    public boolean isPackedArray() {
        return true;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.data);
    }

    @Override
    public Vector toNormal() {
        Vector v = Vector.create(this);
        v.normalise();
        return v;
    }

    @Override
    public Vector toVector() {
        return this;
    }

    @Override
    public double[] asDoubleArray() {
        return this.data;
    }

    @Override
    public Vector dense() {
        return this;
    }

    @Override
    public boolean equals(AVector v) {
        if (v.length() != this.length) {
            return false;
        }
        return v.equalsArray(this.data, 0);
    }

    @Override
    public boolean equalsArray(double[] arr, int offset) {
        return DoubleArrays.equals(this.data, 0, arr, offset, this.length);
    }

    @Override
    protected int index(int i) {
        return i;
    }

    @Override
    public void setElements(double[] values, int offset) {
        System.arraycopy(values, offset, this.data, 0, this.length);
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        System.arraycopy(this.data, 0, dest, destOffset, this.length());
    }
}

