/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz;

import mikera.transformz.ASizedTransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public class OpTransform
extends ASizedTransform {
    private final Op op;

    public OpTransform(Op op, int size) {
        super(size);
        this.op = op;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source);
        this.op.applyTo(dest);
    }

    @Override
    public boolean isInvertible() {
        return this.op.hasInverse();
    }

    @Override
    public OpTransform inverse() {
        Op invOp = this.op.getInverse();
        if (this.op == null) {
            throw new UnsupportedOperationException("Operator " + this.op + " does not have an inverse");
        }
        return new OpTransform(invOp, this.size);
    }
}

