/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.impl.AStridedMatrix;

public abstract class BaseStridedMatrix
extends AStridedMatrix {
    private static final long serialVersionUID = 4101975245958427299L;
    protected final int rowStride;
    protected final int colStride;
    protected final int offset;

    protected BaseStridedMatrix(double[] data, int rowCount, int columnCount, int offset, int rowStride, int columnStride) {
        super(data, rowCount, columnCount);
        this.offset = offset;
        this.rowStride = rowStride;
        this.colStride = columnStride;
    }

    @Override
    public final int rowStride() {
        return this.rowStride;
    }

    @Override
    public final int columnStride() {
        return this.colStride;
    }

    @Override
    public final int getArrayOffset() {
        return this.offset;
    }

    @Override
    public final double get(int i, int j) {
        this.checkIndex(i, j);
        return this.data[this.index(i, j)];
    }

    @Override
    public final double unsafeGet(int i, int j) {
        return this.data[this.index(i, j)];
    }

    @Override
    protected final int index(int row, int col) {
        return this.offset + row * this.rowStride + col * this.colStride;
    }
}

