/*
 * Decompiled with CFR 0.152.
 */
package mikera.example;

import mikera.indexz.Index;
import mikera.indexz.Indexz;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.SparseRowMatrix;
import mikera.util.Rand;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.RepeatedElementVector;
import mikera.vectorz.impl.SparseIndexedVector;

public class SparseMatrix {
    private static int SIZE = 32000;
    private static int DSIZE = 100;
    private static int CSIZE = 200;
    private static int SSIZE = 2000;
    private static long start = 0L;

    private static void printTime(String msg) {
        long now = System.currentTimeMillis();
        System.out.println(msg + (now - start) + "ms");
        SparseMatrix.startTimer();
    }

    private static void startTimer() {
        start = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        int i;
        SparseRowMatrix m = SparseRowMatrix.create(SIZE, SIZE);
        SparseMatrix.startTimer();
        for (i = 0; i < SIZE; ++i) {
            double[] data = new double[DSIZE];
            for (int j = 0; j < DSIZE; ++j) {
                data[j] = Rand.nextDouble();
            }
            Index indy = Indexz.createRandomChoice(DSIZE, SIZE);
            m.replaceRow(i, SparseIndexedVector.create(SIZE, indy, data));
        }
        SparseMatrix.printTime("Construct sparse matrix: ");
        SparseMatrix.startTimer();
        for (i = 0; i < SIZE; ++i) {
            AVector row = m.getRow(i);
            double sum = row.elementSum();
            if (sum > 0.0) {
                row.divide(sum);
                continue;
            }
            m.setRow(i, RepeatedElementVector.create(SIZE, 1.0 / (double)SIZE));
        }
        SparseMatrix.printTime("Normalise all rows: ");
        SparseMatrix.startTimer();
        AMatrix t = Matrixx.createRandomMatrix(SIZE, CSIZE);
        SparseMatrix.printTime("Construct dense matrix: ");
        System.out.println("Dense element sum = " + t.elementSum());
        SparseMatrix.startTimer();
        AMatrix result = m.innerProduct(t);
        SparseMatrix.printTime("Multiply with dense matrix: ");
        System.out.println("Result element sum = " + result.elementSum());
        SparseRowMatrix M = SparseRowMatrix.create(SSIZE, SSIZE);
        SparseMatrix.startTimer();
        for (int i2 = 0; i2 < SSIZE; ++i2) {
            double[] data = new double[DSIZE];
            for (int j = 0; j < DSIZE; ++j) {
                data[j] = Rand.nextDouble();
            }
            Index indy = Indexz.createRandomChoice(DSIZE, SSIZE);
            M.replaceRow(i2, SparseIndexedVector.create(SSIZE, indy, data));
        }
        SparseMatrix.printTime("Construct small sparse matrix: ");
        SparseMatrix.startTimer();
        Matrix D = Matrix.create(M);
        SparseMatrix.printTime("Convert small sparse matrix to dense: ");
        SparseMatrix.startTimer();
        boolean eq = M.equals(D);
        SparseMatrix.printTime("Equality check result (" + eq + "): ");
        SparseMatrix.startTimer();
        eq = D.epsilonEquals(M, 1.0E-6);
        SparseMatrix.printTime("epsilonEquals check result (" + eq + ", should be true): ");
        SparseMatrix.startTimer();
        M.addAt(SSIZE - 1, SSIZE - 1, 3.14159);
        eq = M.equals(D);
        SparseMatrix.printTime("Equality check result (" + eq + ", should be false): ");
        SparseMatrix.startTimer();
        ((AMatrix)D).addAt(SSIZE - 1, SSIZE - 1, 3.14159);
        eq = M.equals(D);
        SparseMatrix.printTime("Equality check result (" + eq + ", should be true): ");
    }
}

