/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz.impl;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Array;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.ISparse;
import mikera.arrayz.impl.IDense;
import mikera.arrayz.impl.ImmutableArray;
import mikera.arrayz.impl.JoinedArray;
import mikera.arrayz.impl.SliceArray;
import mikera.arrayz.impl.SliceElementIterator;
import mikera.arrayz.impl.SliceIterator;
import mikera.indexz.AIndex;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.SparseRowMatrix;
import mikera.util.Maths;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.IOperator;
import mikera.vectorz.Op;
import mikera.vectorz.Op2;
import mikera.vectorz.Ops;
import mikera.vectorz.Scalar;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.SingleDoubleIterator;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.LongArrays;
import mikera.vectorz.util.VectorzException;

public abstract class AbstractArray<T>
implements INDArray,
Iterable<T> {
    private static final long serialVersionUID = -958234961396539071L;

    @Override
    public abstract double get();

    @Override
    public abstract double get(int var1);

    @Override
    public double get(long i) {
        return this.get(Tools.toInt(i));
    }

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public double get(long x, long y) {
        return this.get(Tools.toInt(x), Tools.toInt(y));
    }

    @Override
    public double get(long[] xs) {
        int n = xs.length;
        int[] ixs = new int[n];
        for (int i = 0; i < n; ++i) {
            long ix = xs[i];
            ixs[i] = Tools.toInt(ix);
        }
        return this.get(ixs);
    }

    @Override
    public double get(AIndex ix) {
        return this.get(ix.toArray());
    }

    @Override
    public double get(Index ix) {
        return this.get(ix.getData());
    }

    @Override
    public int getShape(int dim) {
        return this.getShape()[dim];
    }

    @Override
    public int[] getShapeClone() {
        int n = this.dimensionality();
        int[] sh = new int[n];
        for (int i = 0; i < n; ++i) {
            sh[i] = this.getShape(i);
        }
        return sh;
    }

    @Override
    public long[] getLongShape() {
        return LongArrays.copyOf(this.getShape());
    }

    @Override
    public final boolean epsilonEquals(INDArray a) {
        return this.epsilonEquals(a, 1.0E-7);
    }

    @Override
    public boolean epsilonEquals(INDArray a, double epsilon) {
        int dims = a.dimensionality();
        if (a.dimensionality() != dims) {
            return false;
        }
        if (dims == 0) {
            return Tools.epsilonEquals(this.get(), a.get(), epsilon);
        }
        if (dims == 1) {
            return this.asVector().epsilonEquals(a.asVector(), epsilon);
        }
        int sc = this.sliceCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (s.epsilonEquals(a.slice(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoolean() {
        if (this.dimensionality() == 0) {
            return Tools.isBoolean(this.get());
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (s.isBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSparse() {
        return this instanceof ISparse;
    }

    @Override
    public boolean isDense() {
        return this instanceof IDense;
    }

    @Override
    public boolean isMutable() {
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            if (!this.slice(i).isMutable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            if (this.slice(i).isFullyMutable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyOp(Op op) {
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            this.slice(i).applyOp(op);
        }
    }

    @Override
    public void applyOp(IOperator op) {
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            this.slice(i).applyOp(op);
        }
    }

    @Override
    public void applyOp(Op2 op, INDArray b) {
        int dims = this.dimensionality();
        if (dims > 0) {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).applyOp(op, dims == b.dimensionality() ? b.slice(i) : b);
            }
        } else {
            this.set(op.apply(this.get(), b.get()));
        }
    }

    @Override
    public void applyOp(Op2 op, double b) {
        if (this.dimensionality() > 0) {
            int rc = this.sliceCount();
            for (int i = 0; i < rc; ++i) {
                this.slice(i).applyOp(op, b);
            }
        } else {
            this.set(op.apply(this.get(), b));
        }
    }

    @Override
    public void multiply(double d) {
        if (d == 1.0) {
            return;
        }
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            this.slice(i).multiply(d);
        }
    }

    @Override
    public INDArray multiplyCopy(double d) {
        INDArray r = this.clone();
        r.multiply(d);
        return r;
    }

    @Override
    public INDArray divideCopy(double d) {
        INDArray r = this.clone();
        r.multiply(1.0 / d);
        return r;
    }

    @Override
    public INDArray applyOpCopy(Op op) {
        INDArray r = this.clone();
        r.applyOp(op);
        return r;
    }

    @Override
    public double reduce(Op2 op, double init) {
        double result = init;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result = this.slice(i).reduce(op, result);
        }
        return result;
    }

    @Override
    public double reduce(Op2 op) {
        double result = this.slice(0).reduce(op);
        int n = this.sliceCount();
        for (int i = 1; i < n; ++i) {
            result = this.slice(i).reduce(op, result);
        }
        return result;
    }

    @Override
    public boolean isElementConstrained() {
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            if (!this.slice(i).isElementConstrained()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSameShape(INDArray a) {
        int dims = this.dimensionality();
        if (dims != a.dimensionality()) {
            return false;
        }
        for (int i = 0; i < dims; ++i) {
            if (this.getShape(i) == a.getShape(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AVector asVector() {
        int n = this.sliceCount();
        AVector result = this.slice(0).asVector();
        for (int i = 1; i < n; ++i) {
            result = result.join(this.slice(i).asVector());
        }
        return result;
    }

    @Override
    public void setElements(double[] values, int offset) {
        this.setElements(0, values, offset, Tools.toInt(this.elementCount()));
    }

    @Override
    public void setElements(int pos, double[] values, int offset, int length) {
        int s2;
        if (length == 0) {
            return;
        }
        int ss = Tools.toInt(this.slice(0).elementCount());
        int s1 = pos / ss;
        if (s1 == (s2 = (pos + length - 1) / ss)) {
            this.slice(s1).setElements(pos - s1 * ss, values, offset, length);
            return;
        }
        int si = offset;
        int l1 = (s1 + 1) * ss - pos;
        if (l1 > 0) {
            this.slice(s1).setElements(pos - s1 * ss, values, si, l1);
            si += l1;
        }
        for (int i = s1 + 1; i < s2; ++i) {
            this.slice(i).setElements(values, si);
            si += ss;
        }
        int l2 = pos + length - s2 * ss;
        if (l2 > 0) {
            this.slice(s2).setElements(0, values, si, l2);
        }
    }

    @Override
    public boolean isZero() {
        if (this.dimensionality() == 0) {
            return this.get() == 0.0;
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (s.isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public INDArray ensureMutable() {
        if (this.isFullyMutable() && !this.isView()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public void fill(double value) {
        if (this.dimensionality() == 0) {
            this.set(value);
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.fill(value);
            }
        }
    }

    @Override
    public INDArray innerProduct(double a) {
        return this.multiplyCopy(a);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        int dims = this.dimensionality();
        switch (dims) {
            case 0: {
                return a.multiplyCopy(this.get());
            }
            case 1: {
                return this.toVector().innerProduct(a);
            }
        }
        int sc = this.sliceCount();
        ArrayList<INDArray> sliceInnerProducts = new ArrayList<INDArray>(sc);
        for (int i = 0; i < sc; ++i) {
            sliceInnerProducts.add(this.slice(i).innerProduct(a));
        }
        return SliceArray.create(sliceInnerProducts);
    }

    @Override
    public INDArray innerProduct(AScalar s) {
        return this.innerProduct(s.get());
    }

    @Override
    public INDArray innerProduct(AVector a) {
        return this.innerProduct((INDArray)a);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        if (this.dimensionality() == 0) {
            return a.multiplyCopy(this.get());
        }
        ArrayList<INDArray> al = new ArrayList<INDArray>(this.sliceCount());
        for (T s : this) {
            if (s instanceof INDArray) {
                al.add(((INDArray)s).outerProduct(a));
                continue;
            }
            double x = Tools.toDouble(s);
            INDArray sa = a.clone();
            sa.scale(x);
            al.add(sa);
        }
        return Arrayz.create(al);
    }

    @Override
    public INDArray getTranspose() {
        return this.getTransposeCopy();
    }

    @Override
    public INDArray getTransposeView() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getTransposeCopy() {
        Array nd = Array.create(this);
        return nd.getTransposeView();
    }

    @Override
    public final void scale(double d) {
        this.multiply(d);
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        if (factor == 0.0) {
            this.set(constant);
        } else {
            if (factor != 1.0) {
                this.multiply(factor);
            }
            if (constant != 0.0) {
                this.add(constant);
            }
        }
    }

    @Override
    public void scaleAdd(double factor, INDArray b, double bfactor, double constant) {
        this.scaleAdd(factor, constant);
        this.addMultiple(b, bfactor);
    }

    @Override
    public void addMultiple(INDArray src, double factor) {
        if (factor == 0.0) {
            return;
        }
        if (factor == 1.0) {
            this.add(src);
        } else {
            this.add(src.multiplyCopy(factor));
        }
    }

    @Override
    public void addMultipleSparse(INDArray src, double factor) {
        INDArray res = src.multiplyCopy(factor);
        res = res.mutable();
        res.add(this);
        this.setSparse(res);
    }

    @Override
    public void addPower(INDArray src, double exponent) {
        INDArray tmp = src.clone();
        tmp.pow(exponent);
        this.add(tmp);
    }

    @Override
    public void addPower(INDArray src, double exponent, double factor) {
        INDArray tmp = src.clone();
        tmp.pow(exponent);
        this.addMultiple(tmp, factor);
    }

    @Override
    public void addInnerProduct(INDArray a, INDArray b) {
        if (a.dimensionality() == 0) {
            this.addMultiple(b, a.get());
        } else if (a instanceof AMatrix) {
            this.addInnerProduct((AMatrix)a, b);
        } else if (a instanceof AVector) {
            this.addInnerProduct((AVector)a, b);
        } else {
            this.add(a.innerProduct(b));
        }
    }

    @Override
    public void addInnerProduct(INDArray a, INDArray b, double d) {
        if (a.elementCount() < b.elementCount()) {
            this.addInnerProduct(a.multiplyCopy(d), b);
        } else {
            this.addInnerProduct(a, b.multiplyCopy(d));
        }
    }

    public void addInnerProduct(AMatrix a, INDArray b) {
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            this.slice(i).addInnerProduct(a.getRow(i), b);
        }
    }

    public void addInnerProduct(AVector a, INDArray b) {
        int n = a.length();
        if (b.getShape(0) != n) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(a, b));
        }
        for (int i = 0; i < n; ++i) {
            this.addMultiple(b.slice(i), a.unsafeGet(i));
        }
    }

    @Override
    public void addOuterProduct(INDArray a, INDArray b) {
        if (a.dimensionality() == 0) {
            this.addMultiple(b, a.get());
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).addOuterProduct(a.slice(i), b);
            }
        }
    }

    @Override
    public void addOuterProductSparse(INDArray a, INDArray b) {
        if (a.dimensionality() == 0) {
            this.addMultipleSparse(b, a.get());
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).addOuterProductSparse(a.slice(i), b);
            }
        }
    }

    @Override
    public void addSparse(double c) {
        if (this.dimensionality() == 0) {
            this.add(c);
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).addSparse(c);
            }
        }
    }

    @Override
    public void addSparse(INDArray a) {
        int adims = a.dimensionality();
        if (adims == 0) {
            this.addSparse(a.get());
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).addSparse(a.slice(i));
            }
        }
    }

    @Override
    public void setInnerProduct(INDArray a, INDArray b) {
        this.set(a.innerProduct(b));
    }

    @Override
    public void setMultiple(INDArray a, INDArray b) {
        this.set(a);
        this.multiply(b);
    }

    @Override
    public void setMultiple(INDArray a, double b) {
        this.set(a);
        this.scale(b);
    }

    @Override
    public void setSparse(INDArray a) {
        this.set(a);
    }

    @Override
    public void setSparse(double value) {
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.setSparse(value);
        }
    }

    @Override
    public INDArray addCopy(double d) {
        INDArray result = this.clone();
        result.add(d);
        return result;
    }

    public final INDArray addCopy(AScalar a) {
        return this.addCopy(a.get());
    }

    @Override
    public void set(double value) {
        this.set(new int[0], value);
    }

    @Override
    public void set(int x, double value) {
        this.set(new int[]{x}, value);
    }

    @Override
    public void set(int x, int y, double value) {
        this.set(new int[]{x, y}, value);
    }

    @Override
    public void set(long[] xs, double value) {
        this.set(IntArrays.copyOf(xs), value);
    }

    @Override
    public void set(INDArray a) {
        int tdims = this.dimensionality();
        int adims = a.dimensionality();
        if (adims < tdims) {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a);
            }
        } else if (adims == tdims) {
            if (tdims == 0) {
                this.set(a.get());
                return;
            }
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a.slice(i));
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void setApplyOp(Op op, INDArray a) {
        int adims;
        int dims = this.dimensionality();
        if (dims == (adims = a.dimensionality())) {
            this.set(a);
            this.applyOp(op);
        } else if (dims > adims) {
            INDArray sl = this.slice(0);
            int sc = this.sliceCount();
            sl.setApplyOp(op, a);
            for (int i = 1; i < sc; ++i) {
                this.slice(i).set(sl);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void addApplyOp(Op op, INDArray a) {
        this.add(a.applyOpCopy(op));
    }

    @Override
    public void clamp(double min, double max) {
        if (this.dimensionality() == 0) {
            this.set(Maths.bound(this.get(), min, max));
            return;
        }
        int len = this.sliceCount();
        for (int i = 0; i < len; ++i) {
            this.slice(i).clamp(min, max);
        }
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
            return;
        }
        if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
            return;
        }
        if (o instanceof Iterable) {
            int i = 0;
            for (Object ob : (Iterable)o) {
                this.slice(i).set(ob);
            }
            return;
        }
        if (o instanceof double[]) {
            this.setElements((double[])o);
            return;
        }
        throw new UnsupportedOperationException("Can't set to value for " + o.getClass().toString());
    }

    @Override
    public void setElements(double ... values) {
        int vl = values.length;
        if ((long)vl != this.elementCount()) {
            throw new IllegalArgumentException("Wrong array length: " + vl);
        }
        this.setElements(0, values, 0, vl);
    }

    @Override
    public void square() {
        this.applyOp(Ops.SQUARE);
    }

    @Override
    public INDArray squareCopy() {
        INDArray r = this.clone();
        r.square();
        return r;
    }

    @Override
    public INDArray absCopy() {
        INDArray r = this.clone();
        r.abs();
        return r;
    }

    @Override
    public INDArray reciprocalCopy() {
        INDArray r = this.clone();
        r.reciprocal();
        return r;
    }

    @Override
    public INDArray signumCopy() {
        INDArray r = this.clone();
        r.signum();
        return r;
    }

    @Override
    public Iterator<T> iterator() {
        return new SliceIterator(this);
    }

    @Override
    public Iterator<Double> elementIterator() {
        if (this.dimensionality() == 0) {
            return new SingleDoubleIterator(this.get());
        }
        return new SliceElementIterator(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INDArray)) {
            return false;
        }
        return this.equals((INDArray)o);
    }

    @Override
    public boolean equalsArray(double[] data) {
        if ((long)data.length != this.elementCount()) {
            return false;
        }
        return this.equalsArray(data, 0);
    }

    public int hashCode() {
        return this.asVector().hashCode();
    }

    public String toString() {
        if (this.elementCount() > 10000L) {
            Index shape = Index.create(this.getShape());
            return "Large array with shape: " + shape.toString();
        }
        return this.toStringFull();
    }

    public String toStringFull() {
        if (this.dimensionality() == 0) {
            return Double.toString(this.get());
        }
        StringBuilder sb = new StringBuilder();
        int length = this.sliceCount();
        sb.append('[');
        if (length > 0) {
            sb.append(this.slice(0).toString());
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.slice(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public INDArray clone() {
        return Arrayz.create(this);
    }

    @Override
    public INDArray copy() {
        if (!this.isMutable()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public INDArray scaleCopy(double d) {
        INDArray r = this.clone();
        r.scale(d);
        return r;
    }

    @Override
    public INDArray negateCopy() {
        INDArray r = this.clone();
        r.negate();
        return r;
    }

    @Override
    public boolean equals(INDArray a) {
        int dims = this.dimensionality();
        if (a.dimensionality() != dims) {
            return false;
        }
        if (dims == 0) {
            return Tools.equals(this.get(), a.get());
        }
        if (dims == 1) {
            return this.equals(a.asVector());
        }
        int sc = this.sliceCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(AVector a) {
        if (this.dimensionality() != 1) {
            return false;
        }
        return this.asVector().equals(a);
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        int dims = this.dimensionality();
        if (dims == 0) {
            return data[offset] == this.get();
        }
        if (dims == 1) {
            return this.asVector().equalsArray(data, offset);
        }
        int sc = this.sliceCount();
        if (sc == 0) {
            return true;
        }
        int skip = Tools.toInt(this.slice(0).elementCount());
        for (int i = 0; i < sc; ++i) {
            if (this.slice(i).equalsArray(data, offset + i * skip)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(INDArray a) {
        int dims = this.dimensionality();
        if (dims == 0) {
            this.add(a.get());
            return;
        }
        int adims = a.dimensionality();
        int n = this.sliceCount();
        int na = a.sliceCount();
        if (dims == adims) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    public final void sub(AScalar a) {
        this.add(-a.get());
    }

    public final void add(AScalar a) {
        this.add(a.get());
    }

    @Override
    public void add(double a) {
        if (a == 0.0) {
            return;
        }
        int dims = this.dimensionality();
        if (dims == 0) {
            this.set(a + this.get());
        } else {
            int n = this.sliceCount();
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a);
            }
        }
    }

    @Override
    public void addAt(long i, double v) {
        long sliceSize = this.elementCount() / (long)this.sliceCount();
        long slice = i / sliceSize;
        this.slice(Tools.toInt(slice)).addAt(i - slice * sliceSize, v);
    }

    @Override
    public INDArray addCopy(INDArray a) {
        INDArray r = this.broadcastCloneLike(a);
        r.add(a);
        return r;
    }

    @Override
    public INDArray subCopy(INDArray a) {
        INDArray r = this.broadcastCloneLike(a);
        r.sub(a);
        return r;
    }

    @Override
    public INDArray multiplyCopy(INDArray a) {
        INDArray r = this.broadcastCloneLike(a);
        r.multiply(a);
        return r;
    }

    @Override
    public INDArray divideCopy(INDArray a) {
        INDArray r = this.broadcastCloneLike(a);
        r.divide(a);
        return r;
    }

    @Override
    public void addToArray(double[] data, int offset) {
        int dims = this.dimensionality();
        if (dims == 0) {
            int n = offset;
            data[n] = data[n] + this.get();
        } else {
            int n = this.sliceCount();
            INDArray s0 = this.slice(0);
            int ec = Tools.toInt(s0.elementCount());
            s0.addToArray(data, offset);
            for (int i = 1; i < n; ++i) {
                this.slice(i).addToArray(data, offset + i * ec);
            }
        }
    }

    @Override
    public void pow(double exponent) {
        int dims = this.dimensionality();
        if (dims == 0) {
            this.set(Math.pow(this.get(), exponent));
        } else {
            int n = this.sliceCount();
            for (int i = 0; i < n; ++i) {
                this.slice(i).pow(exponent);
            }
        }
    }

    @Override
    public void sub(double a) {
        this.add(-a);
    }

    @Override
    public void multiply(INDArray a) {
        int adims = a.dimensionality();
        if (adims == 0) {
            this.multiply(a.get());
            return;
        }
        int dims = this.dimensionality();
        int n = this.sliceCount();
        int na = a.sliceCount();
        if (dims == adims) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).multiply(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).multiply(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void divide(INDArray a) {
        int adims = a.dimensionality();
        if (adims == 0) {
            this.multiply(1.0 / a.get());
            return;
        }
        int dims = this.dimensionality();
        int n = this.sliceCount();
        int na = a.sliceCount();
        if (dims == adims) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).divide(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).divide(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    @Override
    public long nonZeroCount() {
        if (this.dimensionality() == 0) {
            return this.get() == 0.0 ? 0L : 1L;
        }
        long result = 0L;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).nonZeroCount();
        }
        return result;
    }

    public double density() {
        return (double)this.nonZeroCount() / (double)this.elementCount();
    }

    @Override
    public double elementSum() {
        if (this.dimensionality() == 0) {
            return this.get();
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementSum();
        }
        return result;
    }

    @Override
    public double elementProduct() {
        if (this.dimensionality() == 0) {
            return this.get();
        }
        double result = 1.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            if ((result *= this.slice(i).elementProduct()) != 0.0) continue;
            return 0.0;
        }
        return result;
    }

    @Override
    public double elementMax() {
        if (this.dimensionality() == 0) {
            return this.get();
        }
        double result = this.slice(0).elementMax();
        int n = this.sliceCount();
        for (int i = 1; i < n; ++i) {
            double v = this.slice(i).elementMax();
            if (!(v > result)) continue;
            result = v;
        }
        return result;
    }

    @Override
    public boolean elementsEqual(double value) {
        if (this.dimensionality() == 0) {
            return this.get() == value;
        }
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            if (this.slice(i).elementsEqual(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double elementMin() {
        if (this.dimensionality() == 0) {
            return this.get();
        }
        double result = this.slice(0).elementMin();
        int n = this.sliceCount();
        for (int i = 1; i < n; ++i) {
            double v = this.slice(i).elementMin();
            if (!(v < result)) continue;
            result = v;
        }
        return result;
    }

    @Override
    public double elementSquaredSum() {
        if (this.dimensionality() == 0) {
            double value = this.get();
            return value * value;
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementSquaredSum();
        }
        return result;
    }

    @Override
    public void sub(INDArray a) {
        a = a.broadcastLike(this);
        int dims = this.dimensionality();
        if (dims == 0) {
            this.sub(a.get());
            return;
        }
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            this.slice(i).sub(a.slice(i));
        }
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    @Override
    public void reciprocal() {
        if (this.dimensionality() == 0) {
            this.set(1.0 / this.get());
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).reciprocal();
            }
        }
    }

    @Override
    public void abs() {
        if (this.dimensionality() == 0) {
            this.set(Math.abs(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).abs();
            }
        }
    }

    @Override
    public void absDiff(INDArray a) {
        this.sub(a);
        this.abs();
    }

    @Override
    public INDArray absDiffCopy(INDArray a) {
        INDArray res = this.subCopy(a).mutable();
        res.abs();
        return res;
    }

    @Override
    public void sqrt() {
        if (this.dimensionality() == 0) {
            this.set(Math.sqrt(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).sqrt();
            }
        }
    }

    @Override
    public void log() {
        if (this.dimensionality() == 0) {
            this.set(Math.log(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).log();
            }
        }
    }

    @Override
    public void exp() {
        if (this.dimensionality() == 0) {
            this.set(Math.exp(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).exp();
            }
        }
    }

    @Override
    public void signum() {
        if (this.dimensionality() == 0) {
            this.set(Math.signum(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).signum();
            }
        }
    }

    @Override
    public INDArray reshape(int ... targetShape) {
        return Arrayz.createFromVector(this.asVector(), targetShape);
    }

    @Override
    public INDArray reorder(int dim, int[] order) {
        int n = order.length;
        if (n == 0) {
            int[] shape = this.getShapeClone();
            shape[0] = 0;
            return Arrayz.createZeroArray(shape);
        }
        int dims = this.dimensionality();
        if (dim < 0 || dim >= dims) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dim));
        }
        ArrayList<INDArray> newSlices = new ArrayList<INDArray>(n);
        for (int si : order) {
            newSlices.add(this.slice(dim, si));
        }
        int[] shp = this.getShapeClone();
        shp[dim] = n;
        if (dims == 2 && dim == 0) {
            return SparseRowMatrix.create(newSlices, shp[0], shp[1]);
        }
        if (dim == 0) {
            return SliceArray.create(newSlices, shp);
        }
        Array a = Array.newArray(shp);
        for (int di = 0; di < n; ++di) {
            a.slice(dim, di).set(newSlices.get(di));
        }
        return a;
    }

    @Override
    public INDArray reorder(int[] order) {
        return this.reorder(0, order);
    }

    @Override
    public List<?> getSlices(int dimension) {
        int l = this.getShape(dimension);
        ArrayList<INDArray> al = new ArrayList<INDArray>(l);
        for (int i = 0; i < l; ++i) {
            al.add(this.slice(dimension, i));
        }
        return al;
    }

    @Override
    public List<?> getSlices() {
        int n = this.sliceCount();
        ArrayList<INDArray> al = new ArrayList<INDArray>(n);
        for (int i = 0; i < n; ++i) {
            al.add(this.slice(i));
        }
        return al;
    }

    @Override
    public List<INDArray> getSliceViews() {
        int n = this.sliceCount();
        ArrayList<INDArray> al = new ArrayList<INDArray>(n);
        for (int i = 0; i < n; ++i) {
            al.add(this.slice(i));
        }
        return al;
    }

    @Override
    public int componentCount() {
        return 0;
    }

    @Override
    public INDArray getComponent(int k) {
        throw new UnsupportedOperationException("Component based access not supported for class " + this.getClass().getCanonicalName());
    }

    @Override
    public INDArray[] getComponents() {
        int cc = this.componentCount();
        INDArray[] result = new INDArray[cc];
        for (int i = 0; i < cc; ++i) {
            result[i] = this.getComponent(i);
        }
        return result;
    }

    @Override
    public INDArray withComponents(INDArray ... cs) {
        throw new UnsupportedOperationException("Component re-wrapping not supported for class " + this.getClass().getCanonicalName());
    }

    @Override
    public INDArray subArray(int[] offsets, int[] shape) {
        int n = this.dimensionality();
        if (offsets.length != n) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, offsets));
        }
        int[] thisShape = this.getShape();
        if (IntArrays.equals(shape, thisShape)) {
            if (IntArrays.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        int nslices = shape[0];
        if (nslices == 0) {
            return Array.newArray(shape);
        }
        ArrayList<INDArray> al = new ArrayList<INDArray>(nslices);
        int endIndex = offsets[0] + nslices;
        int[] zzoffsets = IntArrays.removeIndex(offsets, 0);
        int[] zzshape = IntArrays.removeIndex(shape, 0);
        for (int i = offsets[0]; i < endIndex; ++i) {
            al.add(this.slice(i).subArray(zzoffsets, zzshape));
        }
        return SliceArray.create(al);
    }

    @Override
    public INDArray join(INDArray a, int dimension) {
        return JoinedArray.join(this, a, dimension);
    }

    @Override
    public INDArray join(INDArray a) {
        return this.join(a, 0);
    }

    @Override
    public INDArray rotateView(int dimension, int shift) {
        int dlen = this.getShape(dimension);
        if (dlen == 0) {
            return this;
        }
        if ((shift = Maths.mod(shift, dlen)) == 0) {
            return this;
        }
        int n = this.dimensionality();
        int[] off = new int[n];
        int[] shp = this.getShapeClone();
        shp[dimension] = shift;
        INDArray right = this.subArray(off, shp);
        shp[dimension] = dlen - shift;
        off[dimension] = shift;
        INDArray left = this.subArray(off, shp);
        return left.join(right, dimension);
    }

    @Override
    public Vector toVector() {
        int n = Tools.toInt(this.elementCount());
        double[] data = new double[n];
        this.getElements(data, 0);
        return Vector.wrap(data);
    }

    @Override
    public List<Double> asElementList() {
        return this.asVector().asElementList();
    }

    @Override
    public final double[] getElements() {
        return this.toDoubleArray();
    }

    @Override
    public void getElements(double[] dest, int offset) {
        if (this.dimensionality() == 0) {
            dest[offset] = this.get();
            return;
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.getElements(dest, offset);
            offset = (int)((long)offset + s.elementCount());
        }
    }

    @Override
    public void getElements(Object[] dest, int offset) {
        if (this.dimensionality() == 0) {
            dest[offset] = this.get();
            return;
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.getElements(dest, offset);
            offset = (int)((long)offset + s.elementCount());
        }
    }

    @Override
    public void getElements(double[] arr) {
        if ((long)arr.length != this.elementCount()) {
            throw new IllegalArgumentException(ErrorMessages.wrongElementCount());
        }
        this.getElements(arr, 0);
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.toDoubleBuffer(dest);
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] result = DoubleArrays.createStorageArray(this.getShape());
        if (this.isSparse()) {
            this.addToArray(result, 0);
        } else {
            this.getElements(result, 0);
        }
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        return null;
    }

    @Override
    public INDArray[] toSliceArray() {
        int n = this.sliceCount();
        INDArray[] al = new INDArray[n];
        for (int i = 0; i < n; ++i) {
            al[i] = this.slice(i);
        }
        return al;
    }

    @Override
    public Object sliceValue(int i) {
        if (this.dimensionality() == 1) {
            return this.get(i);
        }
        return this.slice(i);
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        int dims = this.dimensionality();
        if (tdims < dims) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, targetShape));
        }
        if (dims == tdims) {
            if (IntArrays.equals(targetShape, this.getShape())) {
                return this;
            }
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, targetShape));
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    @Override
    public INDArray immutable() {
        if (!this.isMutable()) {
            return this;
        }
        return ImmutableArray.create(this);
    }

    @Override
    public INDArray mutable() {
        if (this.isFullyMutable() && !this.isView()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public INDArray sparse() {
        if (this instanceof ISparse) {
            return this;
        }
        return this.sparseClone();
    }

    @Override
    public INDArray sparseClone() {
        int dims = this.dimensionality();
        switch (dims) {
            case 0: {
                return Scalar.create(this.get());
            }
            case 1: {
                return Vectorz.createSparseMutable(this.asVector());
            }
            case 2: {
                return Matrixx.createSparseRows(this);
            }
        }
        int n = this.sliceCount();
        List<INDArray> sls = this.getSliceViews();
        for (int i = 0; i < n; ++i) {
            sls.set(i, sls.get(i).sparseClone());
        }
        return SliceArray.create(sls);
    }

    @Override
    public INDArray dense() {
        if (this instanceof IDense) {
            return this;
        }
        return this.denseClone();
    }

    @Override
    public INDArray denseClone() {
        int dims = this.dimensionality();
        switch (dims) {
            case 0: {
                return Scalar.create(this.get());
            }
            case 1: {
                return Vector.create(this);
            }
            case 2: {
                return Matrix.create(this);
            }
        }
        return Array.create(this);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        return this.broadcast(target.getShape());
    }

    @Override
    public AMatrix broadcastLike(AMatrix target) {
        return Matrixx.toMatrix(this.broadcast(target.getShape()));
    }

    @Override
    public AVector broadcastLike(AVector target) {
        return Vectorz.toVector(this.broadcast(target.getShape()));
    }

    @Override
    public INDArray broadcastCloneLike(INDArray target) {
        int dims = this.dimensionality();
        int targetDims = target.dimensionality();
        INDArray r = this;
        if (dims < targetDims) {
            r = r.broadcastLike(target);
        }
        return r.clone();
    }

    @Override
    public INDArray broadcastCopyLike(INDArray target) {
        if (this.isMutable()) {
            return this.broadcastCloneLike(target);
        }
        return this.broadcastLike(target);
    }

    @Override
    public void validate() {
        if (this.elementCount() != IntArrays.arrayProduct(this.getShape())) {
            throw new VectorzException("Element count not correct");
        }
    }

    protected void checkDimension(int dimension) {
        if (dimension < 0 || dimension >= this.dimensionality()) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dimension));
        }
    }

    @Override
    public boolean hasUncountable() {
        if (this.dimensionality() == 0) {
            return Vectorz.isUncountable(this.get());
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (!s.hasUncountable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double elementPowSum(double p) {
        if (this.dimensionality() == 0) {
            double value = this.get();
            return Math.pow(value, p);
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementPowSum(p);
        }
        return result;
    }

    @Override
    public double elementAbsPowSum(double p) {
        if (this.dimensionality() == 0) {
            double value = Math.abs(this.get());
            return Math.pow(value, p);
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementAbsPowSum(p);
        }
        return result;
    }

    @Override
    public AVector reduceSlices(Op2 op) {
        int sc = this.sliceCount();
        Vector result = Vector.createLength(sc);
        for (int i = 0; i < sc; ++i) {
            ((AVector)result).unsafeSet(i, this.slice(i).reduce(op));
        }
        return result;
    }

    @Override
    public int compareTo(INDArray a) {
        int dims = this.dimensionality();
        if (dims != a.dimensionality()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        if (dims == 0) {
            return Double.compare(this.get(), a.get());
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            int result = this.slice(i).compareTo(a.slice(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public AVector reduceSlices(Op2 op, double init) {
        int sc = this.sliceCount();
        Vector result = Vector.createLength(sc);
        for (int i = 0; i < sc; ++i) {
            ((AVector)result).unsafeSet(i, this.slice(i).reduce(op, init));
        }
        return result;
    }

    @Override
    public double elementMaxAbs() {
        if (this.elementCount() == 0L) {
            throw new IllegalArgumentException(ErrorMessages.noElements(this));
        }
        return this.reduce(Ops.MAX_ABS, 0.0);
    }
}

