/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.JUnitTests;
import math.jwave.Transform;
import math.jwave.exc.JWaveException;
import math.jwave.transforms.FastWaveletTransform;
import math.jwave.transforms.wavelets.Coif06;
import math.jwave.transforms.wavelets.Daub02;
import math.jwave.transforms.wavelets.Daub03;
import math.jwave.transforms.wavelets.Daub04;
import math.jwave.transforms.wavelets.Haar02;
import math.jwave.transforms.wavelets.Haar02Orthogonal;
import math.jwave.transforms.wavelets.Lege02;
import math.jwave.transforms.wavelets.Lege04;
import math.jwave.transforms.wavelets.Lege06;
import math.jwave.transforms.wavelets.Wavelet;
import org.junit.Test;

public class FastWaveletTransformTest
extends JUnitTests {
    @Test
    public void testFastBasicTransformForwardHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02ArrayLong() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02ArrayLong");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02ArrayLong() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02ArrayLong");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02ArrayRandom() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02ArrayRandom");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{9.333809511662427, -1.2727922061357857, -2.1999999999999997, 2.2, -0.7778174593052021, -0.7778174593052025, 0.7778174593052025, 0.7778174593052023};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02ArrayRandom() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02ArrayRandom");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{9.333809511662427, -1.2727922061357857, -2.1999999999999997, 2.2, -0.7778174593052021, -0.7778174593052025, 0.7778174593052025, 0.7778174593052023};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02Matrix() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02Matrix");
        double delta = 1.0E-12;
        double[][] matrixTime = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        this.showTime(matrixTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[][] matrixHilb = t.forward(matrixTime);
        this.showHilb(matrixHilb);
        double[][] expected = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.assertMatrix(expected, matrixHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02Matrix() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02Matrix");
        double delta = 1.0E-12;
        double[][] matrixHilb = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.showHilb(matrixHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[][] matrixTime = t.reverse(matrixHilb);
        this.showTime(matrixTime);
        double[][] expected = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        this.assertMatrix(expected, matrixTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02Space() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02Space");
        double delta = 1.0E-12;
        double[][][] spaceTime = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        this.showTime(spaceTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[][][] spaceHilb = t.forward(spaceTime);
        this.showHilb(spaceHilb);
        double[][][] expected = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
        this.assertSpace(expected, spaceHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02Space() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02Space");
        double delta = 1.0E-12;
        double[][][] spaceHilb = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
        this.showHilb(spaceHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02()));
        double[][][] spaceTime = t.reverse(spaceHilb);
        this.showTime(spaceTime);
        double[][][] expected = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        this.assertSpace(expected, spaceTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02OrthogonalArray() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02OrthogonalArray");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Haar02Orthogonal()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{4.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02OrthogonalArray() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02OrthogonalArray");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{4.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Haar02Orthogonal()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardLege02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardLege02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Lege02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseLege02Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseLege02Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Lege02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardDaub04Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardDaub04Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Daub02()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseDaub04Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseDaub04Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Daub02()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardLege04Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardLege04Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Lege04()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseLege04Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseLege04Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Lege04()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardDaub06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardDaub06Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Daub03()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseDaub06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseDaub06Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Daub03()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardLege06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardLege06Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Lege06()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseLege06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseLege06Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Lege06()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardCoif06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardCoif06Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Coif06()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseCoif06Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseCoif06Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Coif06()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardDaub08Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardDaub04Array");
        double delta = 0.001;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Daub04()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseDaub08Array() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseDaub04Array");
        double delta = 0.001;
        double[] arrHilb = new double[]{2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Daub04()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardDaub04ArrayLong() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardDaub04ArrayLong");
        double delta = 0.01;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform(new Daub04()));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseDaub04ArrayLong() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseDaub04ArrayLong");
        double delta = 0.01;
        double[] arrHilb = new double[]{4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform(new Daub04()));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double[] expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.assertArray(expected, arrTime, delta);
    }

    @Test
    public void testFastBasicTransformForwardHaar02ArraySteps() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformForwardHaar02Array");
        double delta = 1.0E-12;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
        this.showTime(arrTime);
        Transform t = new Transform(new FastWaveletTransform((Wavelet)new Haar02(), 1));
        double[] arrHilb = t.forward(arrTime);
        this.showHilb(arrHilb);
        double[] expected = new double[]{Math.sqrt(2.0), Math.sqrt(2.0), 0.0, 0.0};
        this.assertArray(expected, arrHilb, delta);
    }

    @Test
    public void testFastBasicTransformReverseHaar02ArraySteps() throws JWaveException {
        System.out.println("");
        System.out.println("testFastBasicTransformReverseHaar02Array");
        double delta = 1.0E-12;
        double[] arrHilb = new double[]{2.0, 0.0, 0.0, 0.0};
        this.showHilb(arrHilb);
        Transform t = new Transform(new FastWaveletTransform((Wavelet)new Haar02(), 1));
        double[] arrTime = t.reverse(arrHilb);
        this.showTime(arrTime);
        double sqrt2 = Math.sqrt(2.0);
        double[] expected = new double[]{sqrt2, sqrt2, 0.0, 0.0};
        this.assertArray(expected, arrTime, delta);
    }
}

