/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms;

import math.jwave.exc.JWaveException;
import math.jwave.tools.AncientEgyptianMultiplication;
import math.jwave.transforms.BasicTransform;

public class AncientEgyptianDecomposition
extends BasicTransform {
    protected BasicTransform _waveTransform;
    private AncientEgyptianMultiplication _ancientEgyptianMultiplication;

    public AncientEgyptianDecomposition(BasicTransform waveTransform) {
        this._waveTransform = waveTransform;
        this._ancientEgyptianMultiplication = new AncientEgyptianMultiplication();
    }

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        int[] ancientEgyptianMultipliers = null;
        try {
            ancientEgyptianMultipliers = this._ancientEgyptianMultiplication.decompose(arrTime.length);
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
        int offSet = 0;
        for (int m = 0; m < ancientEgyptianMultipliers.length; ++m) {
            int ancientEgyptianMultiplier = ancientEgyptianMultipliers[m];
            int arrTimeSubLength = (int)this._ancientEgyptianMultiplication.scalb(1.0, ancientEgyptianMultiplier);
            double[] arrTimeSub = new double[arrTimeSubLength];
            for (int i = 0; i < arrTimeSub.length; ++i) {
                arrTimeSub[i] = arrTime[i + offSet];
            }
            double[] arrHilbSub = this._waveTransform.forward(arrTimeSub);
            for (int i = 0; i < arrHilbSub.length; ++i) {
                arrHilb[i + offSet] = arrHilbSub[i];
            }
            offSet += arrHilbSub.length;
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        double[] arrTime = new double[arrHilb.length];
        int[] ancientEgyptianMultipliers = null;
        try {
            ancientEgyptianMultipliers = this._ancientEgyptianMultiplication.decompose(arrHilb.length);
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
        int offSet = 0;
        for (int m = 0; m < ancientEgyptianMultipliers.length; ++m) {
            int ancientEgyptianMultiplier = ancientEgyptianMultipliers[m];
            int arrHilbSubLength = (int)this._ancientEgyptianMultiplication.scalb(1.0, ancientEgyptianMultiplier);
            double[] arrHilbSub = new double[arrHilbSubLength];
            for (int i = 0; i < arrHilbSub.length; ++i) {
                arrHilbSub[i] = arrHilb[i + offSet];
            }
            double[] arrTimeSub = this._waveTransform.reverse(arrHilbSub);
            for (int i = 0; i < arrTimeSub.length; ++i) {
                arrTime[i + offSet] = arrTimeSub[i];
            }
            offSet += arrHilbSub.length;
        }
        return arrTime;
    }
}

