/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.tools;

import math.jwave.exc.JWaveError;
import math.jwave.exc.JWaveException;
import math.jwave.exc.JWaveFailure;

public class AncientEgyptianMultiplication {
    public int[] decompose(int number) throws JWaveException {
        if (number < 1) {
            throw new JWaveFailure("the supported number for decomposition is smaller than one");
        }
        int power = this.getExponent(number);
        int[] tmpArr = new int[power + 1];
        int pos = 0;
        double current = number;
        while (current >= 1.0) {
            tmpArr[pos] = power = this.getExponent(current);
            current -= this.scalb(1.0, power);
            ++pos;
        }
        int[] ancientEgyptianMultipliers = new int[pos];
        for (int c = 0; c < pos; ++c) {
            ancientEgyptianMultipliers[c] = tmpArr[c];
        }
        return ancientEgyptianMultipliers;
    }

    public int compose(int[] ancientEgyptianMultipliers) throws JWaveException {
        if (ancientEgyptianMultipliers == null) {
            throw new JWaveError("given array is null");
        }
        int number = 0;
        for (int ancientEgyptianMultiplier : ancientEgyptianMultipliers) {
            number += (int)this.scalb(1.0, ancientEgyptianMultiplier);
        }
        return number;
    }

    public int getExponent(double f) {
        int exp = (int)(Math.log(f) / Math.log(2.0));
        return exp;
    }

    public double scalb(double f, int scaleFactor) {
        double res = f * Math.pow(2.0, scaleFactor);
        return res;
    }
}

