/*
 * Decompiled with CFR 0.152.
 */
package math.jwave;

import math.jwave.Transform;
import math.jwave.datatypes.Complex;
import math.jwave.exc.JWaveException;
import math.jwave.transforms.FastWaveletTransform;
import math.jwave.transforms.wavelets.Coif06;
import math.jwave.transforms.wavelets.Daub02;
import math.jwave.transforms.wavelets.Haar02;
import math.jwave.transforms.wavelets.Wavelet;
import org.junit.Assert;
import org.junit.Test;

public class JUnitTests {
    public void assertArray(Complex[] expected, Complex[] actual, double delta) {
        int expectedLength = expected.length;
        int actualLength = actual.length;
        Assert.assertEquals((long)expectedLength, (long)actualLength);
        for (int c = 0; c < expectedLength; ++c) {
            double expectedReal = expected[c].getReal();
            double expectedImag = expected[c].getImag();
            double actualReal = actual[c].getReal();
            double actualImag = actual[c].getImag();
            Assert.assertEquals((double)expectedReal, (double)actualReal, (double)delta);
            Assert.assertEquals((double)expectedImag, (double)actualImag, (double)delta);
        }
    }

    @Test
    public void testRoundingHaar02FWT() throws JWaveException {
        System.out.println("");
        System.out.println("testRoundingHaar02FWT");
        double delta = 1.0E-8;
        double[] arrTime = new double[]{1.0, 1.0};
        this.testFastBasicTransformRounding(arrTime, new Haar02(), delta);
    }

    @Test
    public void testRoundingDaub04FWT() throws JWaveException {
        System.out.println("");
        System.out.println("testRoundingDaub04FWT");
        double delta = 1.0E-8;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
        this.testFastBasicTransformRounding(arrTime, new Daub02(), delta);
    }

    @Test
    public void testRoundingCoif06FWT() throws JWaveException {
        System.out.println("");
        System.out.println("testRoundingCoif06FWT");
        double delta = 1.0E-8;
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.testFastBasicTransformRounding(arrTime, new Coif06(), delta);
    }

    public void testFastBasicTransformRounding(double[] arr, Wavelet wavelet, double delta) throws JWaveException {
        long noOfSteps = 10000000L;
        noOfSteps = 1000L;
        double[] arrTime = arr;
        this.showTime(arrTime);
        double[] arrTimeRound = new double[arrTime.length];
        for (int c = 0; c < arrTime.length; ++c) {
            arrTimeRound[c] = arrTime[c];
        }
        Transform t = new Transform(new FastWaveletTransform(wavelet));
        System.out.println("");
        System.out.println("");
        System.out.print("Performing: " + noOfSteps + " forward and reverse transforms ...");
        for (long s = 0L; s < noOfSteps; ++s) {
            arrTimeRound = t.reverse(t.forward(arrTimeRound));
        }
        System.out.println("");
        System.out.println("");
        this.assertArray(arrTime, arrTimeRound, delta);
        System.out.println("Input ...");
        this.showTime(arrTime);
        System.out.println("");
        System.out.println("Result ...");
        this.showTime(arrTimeRound);
        System.out.println("");
        double[] arrTimeErrorAbs = new double[arrTimeRound.length];
        for (int c = 0; c < arrTimeRound.length; ++c) {
            arrTimeErrorAbs[c] = Math.abs(arrTimeRound[c] - arrTime[c]);
        }
        System.out.println("Absolute error");
        this.showTime(arrTimeErrorAbs);
        System.out.println("");
        double[] arrTimeErrorRel = new double[arrTimeRound.length];
        for (int c = 0; c < arrTimeRound.length; ++c) {
            arrTimeErrorRel[c] = Math.abs((arrTimeRound[c] - arrTime[c]) * 100.0 / arrTime[c]);
        }
        System.out.println("Relative error [%] ...");
        this.showTime(arrTimeErrorRel);
        System.out.println("");
    }

    protected void assertArray(double[] expected, double[] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)delta);
        }
    }

    protected void assertMatrix(double[][] expected, double[][] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            for (int j = 0; j < expected[i].length; ++j) {
                Assert.assertEquals((double)expected[i][j], (double)actual[i][j], (double)delta);
            }
        }
    }

    protected void assertSpace(double[][][] expected, double[][][] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            for (int j = 0; j < expected[i].length; ++j) {
                for (int k = 0; k < expected[i][j].length; ++k) {
                    Assert.assertEquals((double)expected[i][j][k], (double)actual[i][j][k], (double)delta);
                }
            }
        }
    }

    protected void showTime(double[] arrTime) {
        System.out.print("time domain: \t\t");
        for (int c = 0; c < arrTime.length; ++c) {
            System.out.print(arrTime[c] + " ");
        }
        System.out.println("");
    }

    protected void showFreq(double[] arrFreq) {
        System.out.print("frequency domain: \t");
        for (int c = 0; c < arrFreq.length; ++c) {
            System.out.print(arrFreq[c] + " ");
        }
        System.out.println("");
    }

    protected void showHilb(double[] arrHilb) {
        System.out.print("Hilbert domain: \t");
        for (int c = 0; c < arrHilb.length; ++c) {
            System.out.print(arrHilb[c] + " ");
        }
        System.out.println("");
    }

    protected void showTime(Complex[] arrTime) {
        System.out.print("time domain: \t\t");
        for (int c = 0; c < arrTime.length; ++c) {
            System.out.print(arrTime[c].toString() + " ");
        }
        System.out.println("");
    }

    protected void showFreq(Complex[] arrFreq) {
        System.out.print("frequency domain: \t");
        for (int c = 0; c < arrFreq.length; ++c) {
            System.out.print(arrFreq[c].toString() + " ");
        }
        System.out.println("");
    }

    protected void showTime(double[][] matrixTime) {
        System.out.println("time domain: \t");
        for (int i = 0; i < matrixTime.length; ++i) {
            for (int j = 0; j < matrixTime[i].length; ++j) {
                System.out.print(matrixTime[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][] matrixFreq) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < matrixFreq.length; ++i) {
            for (int j = 0; j < matrixFreq[i].length; ++j) {
                System.out.print(matrixFreq[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][] matrixHilb) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < matrixHilb.length; ++i) {
            for (int j = 0; j < matrixHilb[i].length; ++j) {
                System.out.print(matrixHilb[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showTime(double[][][] spaceTime) {
        System.out.println("time domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][][] spaceTime) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][][] spaceTime) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

