/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.web.example;

import java.util.Calendar;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.holiday.HolidayCalendar;

public class FixedPeriod
extends Period {
    private double notional;
    private Iso4217Currency currency;
    private double fixedRate;
    private BusinessDayConvention businessDayConvention;
    private DaycountCalculator daycountCalculator;
    private HolidayCalendar paymentHolidayCalendar;

    @Override
    public FixedPeriod clone() {
        FixedPeriod period = new FixedPeriod();
        period.setStartCalendar(this.getStartCalendar());
        period.setEndCalendar(this.getEndCalendar());
        period.setReferenceStartCalendar(this.getReferenceStartCalendar());
        period.setReferenceEndCalendar(this.getReferenceEndCalendar());
        period.notional = this.notional;
        period.currency = this.currency;
        period.fixedRate = this.fixedRate;
        period.businessDayConvention = this.businessDayConvention;
        period.daycountCalculator = this.daycountCalculator;
        period.paymentHolidayCalendar = this.paymentHolidayCalendar;
        return period;
    }

    public BusinessDayConvention getBusinessDayConvention() {
        return this.businessDayConvention;
    }

    public void setBusinessDayConvention(BusinessDayConvention businessDayConvention) {
        this.businessDayConvention = businessDayConvention;
    }

    public Iso4217Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Iso4217Currency currency) {
        this.currency = currency;
    }

    public DaycountCalculator getDaycountCalculator() {
        return this.daycountCalculator;
    }

    public void setDaycountCalculator(DaycountCalculator daycountCalculator) {
        this.daycountCalculator = daycountCalculator;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(double fixedRate) {
        this.fixedRate = fixedRate;
    }

    public HolidayCalendar getPaymentHolidayCalendar() {
        return this.paymentHolidayCalendar;
    }

    public void setPaymentHolidayCalendar(HolidayCalendar holidayCalendar) {
        this.paymentHolidayCalendar = holidayCalendar;
    }

    public double getNotional() {
        return this.notional;
    }

    public void setNotional(double notional) {
        this.notional = notional;
    }

    public Calendar getAdjustedStartCalendar() {
        return this.paymentHolidayCalendar.adjust(this.getStartCalendar(), this.getBusinessDayConvention());
    }

    public Calendar getAdjustedEndCalendar() {
        return this.paymentHolidayCalendar.adjust(this.getEndCalendar(), this.getBusinessDayConvention());
    }

    public double getDaycountFraction() {
        return this.daycountCalculator.calculateDaycountFraction(this.getAdjustedStartCalendar(), this.getAdjustedEndCalendar());
    }

    public double getPayment() {
        return this.getDaycountFraction() * this.getNotional() * this.getFixedRate();
    }

    public Calendar getPaymentDate() {
        return this.paymentHolidayCalendar.adjust(this.getAdjustedStartCalendar(), BusinessDayConvention.MODIFIED_FOLLOWING);
    }
}

