/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday;

import java.util.GregorianCalendar;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.holiday.HolidayCalendarSet;
import org.jfin.date.test.holiday.NewYorkHolidayCalendar;

public class HolidayCalendarSetTest
extends TestCase {
    public void testHolidayCalendarSet() {
        HolidayCalendarFactory testHolidayCalendarFactory = HolidayCalendarFactory.newInstance("org.jfin.date.test.holiday.HolidayCalendarFactoryTestImpl");
        HolidayCalendar holidayCalendar = testHolidayCalendarFactory.getHolidayCalendar(new String[]{"LnB", "NyB"});
        HolidayCalendarSetTest.assertTrue((boolean)holidayCalendar.isWeekend(new GregorianCalendar(2006, 0, 1)));
        HolidayCalendarSetTest.assertFalse((boolean)holidayCalendar.isWeekend(new GregorianCalendar(2006, 0, 3)));
        HolidayCalendarSetTest.assertTrue((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2006, 11, 25)));
        HolidayCalendarSetTest.assertTrue((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2007, 0, 1)));
        HolidayCalendarSet holidayCalendarSet = (HolidayCalendarSet)holidayCalendar;
        HolidayCalendarSetTest.assertEquals((int)holidayCalendarSet.getHolidayCalendars().size(), (int)2);
        Iterator<HolidayCalendar> it = holidayCalendarSet.getHolidayCalendars().iterator();
        NewYorkHolidayCalendar nyb = null;
        while (it.hasNext()) {
            HolidayCalendar hc = it.next();
            if (!(hc instanceof NewYorkHolidayCalendar)) continue;
            nyb = (NewYorkHolidayCalendar)hc;
        }
        holidayCalendarSet.removeHolidayCalendar(nyb);
        HolidayCalendarSetTest.assertFalse((boolean)holidayCalendar.isHoliday(new GregorianCalendar(2007, 0, 1)));
    }
}

