/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday;

import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.test.holiday.LondonHolidayCalendar;
import org.jfin.date.test.holiday.NewYorkHolidayCalendar;

public class HolidayCalendarFactoryTestImpl
extends HolidayCalendarFactory {
    @Override
    public HolidayCalendar getHolidayCalendar(String cityIdentifier) throws HolidayCalendarException {
        return this.getHolidayCalendar(cityIdentifier, Period.class);
    }

    @Override
    public <T extends Period> HolidayCalendar<T> getHolidayCalendar(String cityIdentifier, Class<T> c) {
        if (cityIdentifier.equals("LnB")) {
            return new LondonHolidayCalendar();
        }
        if (cityIdentifier.equals("NyB")) {
            return new NewYorkHolidayCalendar();
        }
        throw new HolidayCalendarException("Unknown holiday city " + cityIdentifier);
    }

    @Override
    public String[] getAvailableLocales() {
        return new String[]{"LnB", "NyB"};
    }
}

