/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.text.ParseException;
import junit.framework.TestCase;
import org.jfin.date.Tenor;

public class TenorTest
extends TestCase {
    public void testTenor() throws ParseException {
        this.assertTenor("SN", 0, 6);
        this.assertTenor("S/N", 0, 6);
        this.assertTenor("ON", 0, 6);
        this.assertTenor("O/N", 0, 6);
        this.assertTenor("TN", 1, 6);
        this.assertTenor("T/N", 1, 6);
        this.assertTenor("3D", 3, 6);
        this.assertTenor("10D", 10, 6);
        this.assertTenor("1W", 7, 6);
        this.assertTenor("2W", 14, 6);
        this.assertTenor("20W", 140, 6);
        this.assertTenor("1M", 1, 2);
        this.assertTenor("2M", 2, 2);
        this.assertTenor("20M", 20, 2);
        this.assertTenor("1Y", 1, 1);
        this.assertTenor("2Y", 2, 1);
        this.assertTenor("20Y", 20, 1);
    }

    public void testBadTenor() {
        Tenor tenor = null;
        try {
            tenor = new Tenor("BAD");
        }
        catch (ParseException e) {
            TenorTest.assertNull(tenor);
            return;
        }
        TenorTest.fail((String)"Expected Tenor to throw exception parsing a bad String");
    }

    public void testConstructor() {
        Tenor tenor = new Tenor(5, 1);
        TenorTest.assertEquals((int)tenor.getAmount(), (int)5);
        TenorTest.assertEquals((int)tenor.getCalendarUnit(), (int)1);
    }

    public void assertTenor(String toParse, int periodAmount, int periodUnit) throws ParseException {
        Tenor tenor = new Tenor(toParse);
        TenorTest.assertEquals((int)tenor.getAmount(), (int)periodAmount);
        TenorTest.assertEquals((int)tenor.getCalendarUnit(), (int)periodUnit);
    }
}

