/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.date.Period;
import org.jfin.date.ScheduleCutter;
import org.jfin.date.ScheduleException;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleCutterTest
extends TestCase {
    public void testCutSinglePeriodByDate() throws ParseException {
        Calendar startDate = ISDADateFormat.parse("2006/01/01");
        Calendar endDate = ISDADateFormat.parse("2006/03/01");
        Calendar cutDate = ISDADateFormat.parse("2006/02/01");
        ArrayList<Calendar> cutDates = new ArrayList<Calendar>();
        cutDates.add(cutDate);
        Period period = new Period(startDate, endDate);
        ScheduleCutter<Period> scheduleCutter = new ScheduleCutter<Period>();
        List<Period> resultPeriods = scheduleCutter.cutPeriodByDates(period, cutDates);
        ScheduleCutterTest.assertEquals((int)2, (int)resultPeriods.size());
        Period cutPeriod1 = resultPeriods.get(0);
        Period cutPeriod2 = resultPeriods.get(1);
        ScheduleCutterTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getEndCalendar()));
    }

    public void testCutSinglePeriodByDates() throws ParseException {
        Calendar startDate = ISDADateFormat.parse("2006/01/01");
        Calendar endDate = ISDADateFormat.parse("2006/04/01");
        Calendar cutDate1 = ISDADateFormat.parse("2006/02/01");
        Calendar cutDate2 = ISDADateFormat.parse("2006/03/01");
        ArrayList<Calendar> cutDates = new ArrayList<Calendar>();
        cutDates.add(cutDate1);
        cutDates.add(cutDate2);
        Period period = new Period(startDate, endDate);
        ScheduleCutter<Period> scheduleCutter = new ScheduleCutter<Period>();
        List<Period> resultPeriods = scheduleCutter.cutPeriodByDates(period, cutDates);
        ScheduleCutterTest.assertEquals((int)3, (int)resultPeriods.size());
        Period cutPeriod1 = resultPeriods.get(0);
        Period cutPeriod2 = resultPeriods.get(1);
        Period cutPeriod3 = resultPeriods.get(2);
        ScheduleCutterTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(cutPeriod3.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/04/01", (String)ISDADateFormat.formatFixedLength(cutPeriod3.getEndCalendar()));
    }

    public void testCutMultiplePeriodsByDates() throws ParseException, ScheduleException {
        Calendar startDate1 = ISDADateFormat.parse("2006/01/01");
        Calendar endDate1 = ISDADateFormat.parse("2006/04/01");
        Calendar startDate2 = ISDADateFormat.parse("2006/04/01");
        Calendar endDate2 = ISDADateFormat.parse("2006/07/01");
        Calendar cutDate1 = ISDADateFormat.parse("2006/02/01");
        Calendar cutDate2 = ISDADateFormat.parse("2006/03/01");
        ArrayList<Calendar> cutDates = new ArrayList<Calendar>();
        cutDates.add(cutDate1);
        cutDates.add(cutDate2);
        Period period1 = new Period(startDate1, endDate1);
        Period period2 = new Period(startDate2, endDate2);
        ArrayList<Period> periodsToCut = new ArrayList<Period>();
        periodsToCut.add(period1);
        periodsToCut.add(period2);
        ScheduleCutter<Period> scheduleCutter = new ScheduleCutter<Period>();
        List resultPeriods = scheduleCutter.cutScheduleByDates(periodsToCut, cutDates);
        ScheduleCutterTest.assertEquals((int)4, (int)resultPeriods.size());
        Period cutPeriod1 = (Period)resultPeriods.get(0);
        Period cutPeriod2 = (Period)resultPeriods.get(1);
        Period cutPeriod3 = (Period)resultPeriods.get(2);
        Period cutPeriod4 = (Period)resultPeriods.get(3);
        ScheduleCutterTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod1.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/02/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(cutPeriod2.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/03/01", (String)ISDADateFormat.formatFixedLength(cutPeriod3.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/04/01", (String)ISDADateFormat.formatFixedLength(cutPeriod3.getEndCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/04/01", (String)ISDADateFormat.formatFixedLength(cutPeriod4.getStartCalendar()));
        ScheduleCutterTest.assertEquals((String)"2006/07/01", (String)ISDADateFormat.formatFixedLength(cutPeriod4.getEndCalendar()));
    }

    public void testOverlappingPeriods() throws ParseException {
        Calendar startDate1 = ISDADateFormat.parse("2006/01/01");
        Calendar endDate1 = ISDADateFormat.parse("2006/04/01");
        Calendar startDate2 = ISDADateFormat.parse("2006/03/01");
        Calendar endDate2 = ISDADateFormat.parse("2006/06/01");
        Calendar cutDate1 = ISDADateFormat.parse("2006/02/01");
        ArrayList<Calendar> cutDates = new ArrayList<Calendar>();
        cutDates.add(cutDate1);
        Period period1 = new Period(startDate1, endDate1);
        Period period2 = new Period(startDate2, endDate2);
        ArrayList<Period> periodsToCut = new ArrayList<Period>();
        periodsToCut.add(period1);
        periodsToCut.add(period2);
        ScheduleCutter<Period> scheduleCutter = new ScheduleCutter<Period>();
        try {
            List resultPeriods = scheduleCutter.cutScheduleByDates(periodsToCut, cutDates);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleCutterTest.fail((String)"Failed to throw Schedule Exception.");
    }
}

