/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.jfin.date.holiday.financialcalendarimpl.InfoFileEntry;

public class InfoFile {
    private TreeMap<String, InfoFileEntry> entries = new TreeMap();

    public InfoFile() {
    }

    public InfoFile(File f) throws IOException {
        this();
        this.load(f);
    }

    public void load(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            InfoFileEntry infoFileEntry = new InfoFileEntry(line);
            this.entries.put(infoFileEntry.getCode(), infoFileEntry);
        }
    }

    public void addEntry(InfoFileEntry entry) {
        this.entries.put(entry.getCode(), entry);
    }

    public InfoFileEntry getEntryByCode(String code) {
        return this.entries.get(code);
    }

    public String[] getAvailableCodes() {
        ArrayList<String> codes = new ArrayList<String>(this.entries.keySet());
        Collections.sort(codes);
        String[] codesArray = new String[codes.size()];
        for (int i = 0; i < codes.size(); ++i) {
            codesArray[i] = (String)codes.get(i);
        }
        return codesArray;
    }
}

