/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;

public class US30360
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.US30360");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        boolean isLastDayOfFebruary2;
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        int dayOfMonth1 = startCalendar.get(5);
        int dayOfMonth2 = endCalendar.get(5);
        int month1 = startCalendar.get(2);
        int month2 = endCalendar.get(2);
        int year1 = startCalendar.get(1);
        int year2 = endCalendar.get(1);
        boolean isLastDayOfFebruary1 = dayOfMonth1 == startCalendar.getActualMaximum(5) && month1 == 1;
        boolean bl = isLastDayOfFebruary2 = dayOfMonth2 == startCalendar.getActualMaximum(5) && month2 == 1;
        if (isLastDayOfFebruary1 && isLastDayOfFebruary2) {
            dayOfMonth2 = 30;
        }
        if (isLastDayOfFebruary1) {
            dayOfMonth1 = 30;
        }
        if (dayOfMonth2 == 31 && dayOfMonth1 >= 30) {
            dayOfMonth2 = 30;
        }
        if (dayOfMonth1 == 31) {
            dayOfMonth1 = 30;
        }
        int numerator = 360 * (year2 - year1);
        numerator += 30 * (month2 - month1);
        return (double)(numerator += dayOfMonth2 - dayOfMonth1) / 360.0;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }
}

