/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual;

import java.util.Calendar;
import org.jfin.common.Iso4217Currency;

public class Payment {
    private double amount;
    private Iso4217Currency currency;
    private Calendar paymentCalendar;

    public Payment() {
    }

    public Payment(Payment toCopy) {
        this.amount = toCopy.amount;
        this.currency = toCopy.currency;
        this.paymentCalendar = toCopy.paymentCalendar;
    }

    public Payment clone() {
        return new Payment(this);
    }

    public Payment(double amount, Iso4217Currency currency, Calendar paymentCalendar) {
        this.amount = amount;
        this.currency = currency;
        this.paymentCalendar = paymentCalendar;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Iso4217Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Iso4217Currency currency) {
        this.currency = currency;
    }

    public Calendar getPaymentCalendar() {
        return this.paymentCalendar;
    }

    public void setPaymentCalendar(Calendar paymentCalendar) {
        this.paymentCalendar = paymentCalendar;
    }

    public boolean equalsIgnoringAmount(Payment payment) {
        return this.areCalendarsSameDate(this.paymentCalendar, payment.paymentCalendar) && this.currency == payment.currency;
    }

    public boolean areCalendarsSameDate(Calendar c1, Calendar c2) {
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }
}

