/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual;

import java.util.Calendar;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Initialisable;
import org.jfin.date.Period;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.PaymentType;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.holiday.HolidayCalendar;

public abstract class AccrualPeriod
extends Period
implements Initialisable {
    private Calendar paymentCalendar;
    private PaymentType paymentType;
    private BusinessDayConvention paymentBusinessDayConvention;
    private BusinessDayConvention accrualBusinessDayConvention;
    private HolidayCalendar paymentHolidayCalendar;
    private HolidayCalendar accrualHolidayCalendar;
    private DaycountCalculator daycountCalculator;

    public AccrualPeriod() {
    }

    public AccrualPeriod(Period toCopy) {
        super(toCopy);
        if (toCopy instanceof AccrualPeriod) {
            AccrualPeriod accrualPeriodToCopy = (AccrualPeriod)toCopy;
            if (accrualPeriodToCopy.paymentCalendar != null) {
                this.paymentCalendar = (Calendar)accrualPeriodToCopy.paymentCalendar.clone();
            }
            this.paymentType = accrualPeriodToCopy.paymentType;
            this.paymentBusinessDayConvention = accrualPeriodToCopy.paymentBusinessDayConvention;
            this.paymentHolidayCalendar = accrualPeriodToCopy.paymentHolidayCalendar;
            this.daycountCalculator = accrualPeriodToCopy.daycountCalculator;
            this.accrualBusinessDayConvention = accrualPeriodToCopy.accrualBusinessDayConvention;
            this.accrualHolidayCalendar = accrualPeriodToCopy.accrualHolidayCalendar;
        }
    }

    @Override
    public void initialise() {
        if (this.paymentType != null) {
            switch (this.paymentType) {
                case IN_ADVANCE: {
                    this.setPaymentCalendar(this.getStartCalendar());
                    break;
                }
                case IN_ARREARS: {
                    this.setPaymentCalendar(this.getEndCalendar());
                }
            }
        }
    }

    public abstract double getPaymentAmount(double var1) throws Exception;

    public abstract boolean isPaymentPossible();

    public Calendar getPaymentCalendar() {
        return this.paymentCalendar;
    }

    public Calendar getAdjustedPaymentCalendar() throws AccrualException {
        if (this.paymentBusinessDayConvention == null) {
            throw new AccrualException("Could not get adjusted payment calendar where the payment business day convention is null.");
        }
        if (this.paymentBusinessDayConvention == BusinessDayConvention.UNADJUSTED) {
            return this.getPaymentCalendar();
        }
        if (this.getPaymentCalendar() == null) {
            throw new AccrualException("Could not get adjusted payment calendar where the payment calendar is null.");
        }
        if (this.paymentHolidayCalendar == null) {
            throw new AccrualException("Could not get adjusted payment calendar where the payment holiday calendar is null.");
        }
        return this.paymentHolidayCalendar.adjust(this.getPaymentCalendar(), this.paymentBusinessDayConvention);
    }

    public void setPaymentCalendar(Calendar paymentCalendar) {
        this.paymentCalendar = paymentCalendar;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public BusinessDayConvention getPaymentBusinessDayConvention() {
        return this.paymentBusinessDayConvention;
    }

    public void setPaymentBusinessDayConvention(BusinessDayConvention paymentBusinessDayConvention) {
        this.paymentBusinessDayConvention = paymentBusinessDayConvention;
    }

    public BusinessDayConvention getAccrualBusinessDayConvention() {
        return this.accrualBusinessDayConvention;
    }

    public void setAccrualBusinessDayConvention(BusinessDayConvention accrualBusinessDayConvention) {
        this.accrualBusinessDayConvention = accrualBusinessDayConvention;
    }

    public HolidayCalendar getPaymentHolidayCalendar() {
        return this.paymentHolidayCalendar;
    }

    public void setPaymentHolidayCalendar(HolidayCalendar paymentHolidayCalendar) {
        this.paymentHolidayCalendar = paymentHolidayCalendar;
    }

    public HolidayCalendar getAccrualHolidayCalendar() {
        return this.accrualHolidayCalendar;
    }

    public void setAccrualHolidayCalendar(HolidayCalendar accrualHolidayCalendar) {
        this.accrualHolidayCalendar = accrualHolidayCalendar;
    }

    public DaycountCalculator getDaycountCalculator() {
        return this.daycountCalculator;
    }

    public void setDaycountCalculator(DaycountCalculator daycountCalculator) {
        this.daycountCalculator = daycountCalculator;
    }

    public Calendar getAdjustedStartCalendar() throws AccrualException {
        if (this.accrualBusinessDayConvention == null) {
            throw new AccrualException("Could not get adjusted start calendar where the accrual business day convention is null.");
        }
        if (this.accrualBusinessDayConvention == BusinessDayConvention.UNADJUSTED) {
            return this.getStartCalendar();
        }
        if (this.getStartCalendar() == null) {
            throw new AccrualException("Could not get adjusted start calendar where the start calendar is null.");
        }
        if (this.accrualHolidayCalendar == null) {
            throw new AccrualException("Could not get adjusted start calendar where the accrual holiday calendar is null.");
        }
        return this.accrualHolidayCalendar.adjust(this.getStartCalendar(), this.accrualBusinessDayConvention);
    }

    public Calendar getAdjustedEndCalendar() throws AccrualException {
        if (this.accrualBusinessDayConvention == null) {
            throw new AccrualException("Could not get adjusted end calendar where the accrual business day convention is null.");
        }
        if (this.accrualBusinessDayConvention == BusinessDayConvention.UNADJUSTED) {
            return this.getEndCalendar();
        }
        if (this.getEndCalendar() == null) {
            throw new AccrualException("Could not get adjusted end calendar where the end calendar is null.");
        }
        if (this.accrualHolidayCalendar == null) {
            throw new AccrualException("Could not get adjusted end calendar where the accrual holiday calendar is null.");
        }
        return this.accrualHolidayCalendar.adjust(this.getEndCalendar(), this.accrualBusinessDayConvention);
    }

    public double getAdjustedDaycountFraction() throws AccrualException {
        return this.daycountCalculator.calculateDaycountFraction(this.getAdjustedStartCalendar(), this.getAdjustedEndCalendar());
    }
}

